/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.util;

import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.EnderChickenPart;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Raytracing {
    public static HitResult getFocusedEntityOrBlock(EnderChicken chicken, double range) {
        BlockHitResult result = Raytracing.getFocusedBlock(chicken, range);
        double rangeSq = range * range;
        Pair<Vec3, Vec3> startAndEnd = Raytracing.getStartAndEndLookVec(chicken, range);
        Vec3 eyePos = (Vec3)startAndEnd.getLeft();
        if (result.getType() != HitResult.Type.MISS) {
            rangeSq = result.getLocation().distanceToSqr(eyePos);
        }
        double rangeSq2 = rangeSq;
        Vec3 hitVec = null;
        Entity focusedEntity = null;
        Vec3 lookVec = chicken.getLookAngle().scale(range + 1.0);
        AABB box = chicken.getBoundingBox().inflate(lookVec.x, lookVec.y, lookVec.z);
        for (Entity entity : chicken.level().getEntities((Entity)chicken, box, e -> Raytracing.isValidTarget(e, chicken))) {
            double rangeSq3;
            AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            Optional vec = aabb.clip(eyePos, (Vec3)startAndEnd.getRight());
            if (aabb.contains(eyePos)) {
                if (!(rangeSq2 >= 0.0)) continue;
                focusedEntity = entity;
                hitVec = vec.orElse(eyePos);
                rangeSq2 = 0.0;
                continue;
            }
            if (!vec.isPresent() || !((rangeSq3 = eyePos.distanceToSqr((Vec3)vec.get())) < rangeSq2) && rangeSq2 != 0.0) continue;
            if (entity == entity.getVehicle() && !entity.canRiderInteract()) {
                if (rangeSq2 != 0.0) continue;
                focusedEntity = entity;
                hitVec = (Vec3)vec.get();
                continue;
            }
            focusedEntity = entity;
            hitVec = (Vec3)vec.get();
            rangeSq2 = rangeSq3;
        }
        return focusedEntity != null && rangeSq2 < rangeSq ? new EntityHitResult(focusedEntity, hitVec) : result;
    }

    private static boolean isValidTarget(Entity e, EnderChicken chicken) {
        return e.isPickable() && e != chicken && !(e instanceof EnderChickenPart) && e != chicken.getFirstPassenger();
    }

    public static BlockHitResult getFocusedBlock(EnderChicken chicken, double range) {
        Pair<Vec3, Vec3> vecs = Raytracing.getStartAndEndLookVec(chicken, range);
        ClipContext ctx = new ClipContext((Vec3)vecs.getLeft(), (Vec3)vecs.getRight(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)chicken);
        return chicken.level().clip(ctx);
    }

    private static Pair<Vec3, Vec3> getStartAndEndLookVec(EnderChicken chicken, double range) {
        Vec3 entityVec = chicken.partBill.position();
        Vec3 maxDistVec = entityVec.add(chicken.getViewVector(1.0f).scale(range));
        return new ImmutablePair((Object)chicken.getEyePosition(1.0f), (Object)maxDistVec);
    }
}

