/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockTintedGlass
extends Block {
    public static final BooleanProperty CONNECTED_DOWN = BooleanProperty.create((String)"connected_down");
    public static final BooleanProperty CONNECTED_UP = BooleanProperty.create((String)"connected_up");
    public static final BooleanProperty CONNECTED_NORTH = BooleanProperty.create((String)"connected_north");
    public static final BooleanProperty CONNECTED_SOUTH = BooleanProperty.create((String)"connected_south");
    public static final BooleanProperty CONNECTED_WEST = BooleanProperty.create((String)"connected_west");
    public static final BooleanProperty CONNECTED_EAST = BooleanProperty.create((String)"connected_east");

    public BlockTintedGlass(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CONNECTED_DOWN, (Comparable)Boolean.FALSE)).setValue((Property)CONNECTED_EAST, (Comparable)Boolean.FALSE)).setValue((Property)CONNECTED_NORTH, (Comparable)Boolean.FALSE)).setValue((Property)CONNECTED_SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)CONNECTED_UP, (Comparable)Boolean.FALSE)).setValue((Property)CONNECTED_WEST, (Comparable)Boolean.FALSE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(@Nonnull BlockState state, BlockState adjacentBlockState, @Nonnull Direction side) {
        return adjacentBlockState.is((Block)this) || super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return false;
    }

    public int getLightBlock(@Nonnull BlockState state, BlockGetter world, @Nonnull BlockPos pos) {
        return world.getMaxLightLevel();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.DOWN)))).setValue((Property)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.EAST)))).setValue((Property)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.NORTH)))).setValue((Property)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.SOUTH)))).setValue((Property)CONNECTED_UP, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.UP)))).setValue((Property)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.WEST)));
    }

    @Nonnull
    public BlockState updateShape(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.DOWN)))).setValue((Property)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.EAST)))).setValue((Property)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.NORTH)))).setValue((Property)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.SOUTH)))).setValue((Property)CONNECTED_UP, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.UP)))).setValue((Property)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isSideConnectable((BlockGetter)world, pos, Direction.WEST)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTED_DOWN, CONNECTED_UP, CONNECTED_NORTH, CONNECTED_SOUTH, CONNECTED_WEST, CONNECTED_EAST});
    }

    private boolean isSideConnectable(BlockGetter world, BlockPos pos, Direction side) {
        BlockState stateConnection = world.getBlockState(pos.relative(side));
        return stateConnection != null && stateConnection.getBlock() == this;
    }
}

