/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.BookPageJsonLoader;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BookContentEntry
extends BookEntry {
    protected List<BookPage> pages;

    public BookContentEntry(ResourceLocation id, BookEntry.BookEntryData data, ResourceLocation commandToRunOnFirstReadId, List<BookPage> pages) {
        super(id, data, commandToRunOnFirstReadId);
        this.pages = pages;
    }

    public static BookContentEntry fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions, HolderLookup.Provider provider) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(id, json, autoAddReadConditions, provider);
        ResourceLocation commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            String commandToRunOnFirstReadIdPath = GsonHelper.getAsString((JsonObject)json, (String)"command_to_run_on_first_read");
            commandToRunOnFirstReadId = commandToRunOnFirstReadIdPath.contains(":") ? ResourceLocation.parse((String)commandToRunOnFirstReadIdPath) : ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)commandToRunOnFirstReadIdPath);
        }
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        if (json.has("pages")) {
            JsonArray jsonPages = GsonHelper.getAsJsonArray((JsonObject)json, (String)"pages");
            for (JsonElement pageElem : jsonPages) {
                BookPage page;
                BookErrorManager.get().setContext("Page Index: {}", pages.size());
                JsonObject pageJson = GsonHelper.convertToJsonObject((JsonElement)pageElem, (String)"page");
                ResourceLocation type = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)pageJson, (String)"type"));
                JsonLoader<? extends BookPage> loader = LoaderRegistry.getPageJsonLoader(type);
                if (loader instanceof BookPageJsonLoader) {
                    BookPageJsonLoader bookPageLoader = (BookPageJsonLoader)loader;
                    page = bookPageLoader.fromJson(id, pageJson, provider);
                    pages.add(page);
                    continue;
                }
                page = loader.fromJson(pageJson, provider);
                pages.add(page);
            }
        }
        return new BookContentEntry(id, data, commandToRunOnFirstReadId, pages);
    }

    public static BookContentEntry fromNetwork(RegistryFriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        ResourceLocation commandToRunOnFirstReadId = (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation);
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        int pageCount = buffer.readVarInt();
        for (int i = 0; i < pageCount; ++i) {
            ResourceLocation type = buffer.readResourceLocation();
            NetworkLoader<? extends BookPage> loader = LoaderRegistry.getPageNetworkLoader(type);
            BookPage page = loader.fromNetwork(buffer);
            pages.add(page);
        }
        return new BookContentEntry(id, data, commandToRunOnFirstReadId, pages);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.EntryType.CONTENT;
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.id);
        this.data.toNetwork(buffer);
        buffer.writeNullable((Object)this.commandToRunOnFirstReadId, FriendlyByteBuf::writeResourceLocation);
        buffer.writeVarInt(this.pages.size());
        for (BookPage page : this.pages) {
            buffer.writeResourceLocation(page.getType());
            page.toNetwork(buffer);
        }
    }

    @Override
    public void build(Level level, BookCategory category) {
        super.build(level, category);
        int pageNum = 0;
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = pageNum;
            page.build(level, this, pageNum);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
            ++pageNum;
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = page.getPageNumber();
            page.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
        }
    }

    @Override
    public List<BookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<BookPage> getUnlockedPagesFor(Player player) {
        BookUnlockStateManager unlockManager = BookUnlockStateManager.get();
        return unlockManager.getUnlockedPagesFor(player, this);
    }

    @Override
    public int getPageNumberForAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.getAnchor())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean matchesQuery(String query) {
        if (super.matchesQuery(query)) {
            return true;
        }
        for (BookPage page : this.getPages()) {
            if (!page.matchesQuery(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void openEntry(BookAddress address) {
        BookGuiManager.get().openContentEntry(this, address);
    }
}

