/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block;

import me.desht.modularrouters.block.tile.ICamouflageable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public abstract class CamouflageableBlock
extends Block {
    public static final ModelProperty<BlockState> CAMOUFLAGE_STATE = new ModelProperty();

    CamouflageableBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        ICamouflageable camo = this.getCamoState(reader, pos);
        return camo == null ? this.getUncamouflagedCollisionShape(state, reader, pos, ctx) : camo.getCamouflage().getCollisionShape(reader, pos, ctx);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        ICamouflageable camo = this.getCamoState(reader, pos);
        return camo == null ? this.getUncamouflagedShape(state, reader, pos, ctx) : camo.getCamouflage().getShape(reader, pos, ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null || !camo.extendedMimic() || this.isBlacklisted(camo.getCamouflage()) ? super.getLightEmission(state, world, pos) : camo.getCamouflage().getLightEmission(world, pos);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedRaytraceShape(state, worldIn, pos) : camo.getCamouflage().getVisualShape(worldIn, pos, CollisionContext.empty());
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedRenderShape(state, worldIn, pos) : camo.getCamouflage().getBlockSupportShape(worldIn, pos);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext ctx) {
        ICamouflageable camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedVisualShape(state, worldIn, pos, ctx) : camo.getCamouflage().getVisualShape(worldIn, pos, ctx);
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null ? super.getLightBlock(state, world, pos) : camo.getCamouflage().getLightBlock(world, pos);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(worldIn, pos);
        return camo == null || !camo.extendedMimic() ? super.getDestroyProgress(state, player, worldIn, pos) : camo.getCamouflage().getDestroyProgress(player, worldIn, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null || !camo.extendedMimic() ? super.getExplosionResistance(state, world, pos, explosion) : camo.getCamouflage().getBlock().getExplosionResistance(state, world, pos, explosion);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(reader, pos);
        return camo == null ? super.propagatesSkylightDown(state, reader, pos) : camo.getCamouflage().propagatesSkylightDown(reader, pos);
    }

    ICamouflageable getCamoState(BlockGetter blockAccess, BlockPos pos) {
        ICamouflageable c;
        if (blockAccess == null || pos == null) {
            return null;
        }
        BlockEntity te = blockAccess.getBlockEntity(pos);
        return te instanceof ICamouflageable && (c = (ICamouflageable)te).getCamouflage() != null && !(c.getCamouflage().getBlock() instanceof CamouflageableBlock) ? c : null;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        ICamouflageable camo = this.getCamoState(blockAccess, pos);
        return camo == null || !camo.extendedMimic() ? super.getSignal(blockState, blockAccess, pos, side) : camo.getCamouflage().getSignal(blockAccess, pos, side);
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        ICamouflageable camo = this.getCamoState(blockAccess, pos);
        return camo == null || !camo.extendedMimic() ? super.getSignal(blockState, blockAccess, pos, side) : camo.getCamouflage().getDirectSignal(blockAccess, pos, side);
    }

    public abstract VoxelShape getUncamouflagedShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    protected VoxelShape getUncamouflagedCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.getUncamouflagedShape(state, reader, pos, ctx);
    }

    protected VoxelShape getUncamouflagedVisualShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext ctx) {
        return this.getUncamouflagedCollisionShape(state, worldIn, pos, ctx);
    }

    protected VoxelShape getUncamouflagedRenderShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getUncamouflagedShape(state, reader, pos, CollisionContext.empty());
    }

    protected VoxelShape getUncamouflagedRaytraceShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    private boolean isBlacklisted(BlockState camouflage) {
        return BuiltInRegistries.BLOCK.getKey((Object)camouflage.getBlock()).getNamespace().equals("chiselsandbits");
    }
}

