/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.monocle.bootstrap;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileReader;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisModParser
implements IModFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Monocle/IrisModParser");
    private static final Set<String> DEPS_TO_STRIP = Set.of("sodium", "embeddium");

    @Nullable
    public IModFile read(JarContents contents, ModFileDiscoveryAttributes attributes) {
        Optional<CommentedConfig> modifiedToml = IrisModParser.getModifiedTomlFile(contents);
        if (modifiedToml.isEmpty()) {
            return null;
        }
        LOGGER.info("Handling parsing of neoforge.mods.toml from {}", (Object)contents.getPrimaryPath().getFileName().toString());
        ModJarMetadata mjm = new ModJarMetadata(contents);
        IModFile mod = IModFile.create((SecureJar)SecureJar.from((JarContents)contents, (JarMetadata)mjm), modFile -> {
            NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)modifiedToml.get());
            return new ModFileInfo((ModFile)modFile, (IConfigurable)configWrapper, arg_0 -> ((NightConfigWrapper)configWrapper).setFile(arg_0), List.of());
        }, (ModFileDiscoveryAttributes)attributes);
        mjm.setModFile(mod);
        return mod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<CommentedConfig> getModifiedTomlFile(JarContents contents) {
        Optional modsToml = contents.findFile("META-INF/neoforge.mods.toml");
        if (!modsToml.isPresent()) return Optional.empty();
        try (InputStreamReader reader = new InputStreamReader(((URI)modsToml.get()).toURL().openStream());){
            CommentedConfig config = new TomlParser().parse((Reader)reader);
            List deps = (List)config.get("dependencies.iris");
            if (deps == null) return Optional.empty();
            if (!deps.removeIf(dep -> DEPS_TO_STRIP.contains((String)dep.get("modId")))) {
                Optional<CommentedConfig> optional = Optional.empty();
                return optional;
            }
            if (deps.isEmpty()) {
                config.remove("dependencies.iris");
            }
            Optional<CommentedConfig> optional = Optional.of(config);
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Exception reading mod file", (Throwable)e);
        }
        return Optional.empty();
    }

    public int getPriority() {
        return 1001;
    }
}

