/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.block;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.block.entity.FluidCowJarBlockEntity;
import com.portingdeadmods.moofluids.block.entity.MFBlockEntities;
import com.portingdeadmods.moofluids.data.CowJarDataComponent;
import com.portingdeadmods.moofluids.entity.FluidCow;
import com.portingdeadmods.moofluids.entity.MFEntities;
import com.portingdeadmods.moofluids.items.FluidCowJarBlockItem;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidCowJarBlock
extends BaseEntityBlock {
    public static final MapCodec<FluidCowJarBlock> CODEC = FluidCowJarBlock.simpleCodec(FluidCowJarBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.create((String)"light_level", (int)0, (int)15);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));

    public FluidCowJarBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.GLASS).strength(0.6f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        BlockEntity blockEntity = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof FluidCowJarBlockEntity) {
            FluidCowJarBlockEntity fluidCowJar = (FluidCowJarBlockEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            fluidCowJar.saveToItem(itemStack, (HolderLookup.Provider)params.getLevel().registryAccess());
            return Collections.singletonList(itemStack);
        }
        return super.getDrops(state, params);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof FluidCowJarBlockEntity) {
            FluidCowJarBlockEntity fluidCowJar = (FluidCowJarBlockEntity)blockEntity;
            CowJarDataComponent cowData = (CowJarDataComponent)stack.get(FluidCowJarBlockItem.COW_JAR_DATA.get());
            if (cowData != null && cowData.hasCow()) {
                fluidCowJar.loadFromItem(cowData, (SimpleFluidContent)stack.get(FluidCowJarBlockItem.FLUID_TANK.get()));
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIGHT_LEVEL});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        FluidCowJarBlockEntity fluidCowJar;
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof FluidCowJarBlockEntity && (fluidCowJar = (FluidCowJarBlockEntity)blockEntity).hasCow()) {
            if (FluidUtils.isFluidBlacklisted(fluidCowJar.getCowFluid())) {
                player.displayClientMessage((Component)Component.translatable((String)"message.moofluids.cow_blacklisted"), true);
                return InteractionResult.SUCCESS;
            }
            FluidCow cow = new FluidCow(MFEntities.FLUID_COW.get(), level);
            cow.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
            cow.setFluid(fluidCowJar.getCowFluid().builtInRegistryHolder().key().location().toString());
            cow.setDelay(0);
            if (fluidCowJar.hasCustomName()) {
                cow.setCustomName(fluidCowJar.getCustomName());
            }
            level.addFreshEntity((Entity)cow);
            fluidCowJar.removeFluidCow();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FluidCowJarBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        FluidCowJarBlockEntity fluidCowJar = (FluidCowJarBlockEntity)blockEntity;
        if (stack.getItem() == Items.BUCKET) {
            FluidStack drained = fluidCowJar.getFluidTank().drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && drained.getAmount() >= 1000) {
                if (stack.getCount() == 1) {
                    fluidCowJar.getFluidTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack filledBucket = FluidUtil.getFilledBucket((FluidStack)drained);
                    if (!player.getAbilities().instabuild) {
                        player.setItemInHand(hand, filledBucket);
                    }
                } else {
                    ItemStack filledBucket = FluidUtil.getFilledBucket((FluidStack)drained);
                    if (player.getInventory().add(filledBucket)) {
                        fluidCowJar.getFluidTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        if (!player.getAbilities().instabuild) {
                            stack.shrink(1);
                        }
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            int filled;
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (!fluidStack.isEmpty() && (filled = fluidCowJar.getFluidTank().fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) >= 1000) {
                fluidCowJar.getFluidTank().fill(new FluidStack(fluidStack.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                if (!player.getAbilities().instabuild) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.stepOn(level, pos, state, entity);
        if (!level.isClientSide) {
            this.checkForAnvilCrushing(level, pos, state, entity);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.isClientSide) {
            this.checkForAnvilAbove(level, pos, state);
        }
    }

    private void checkForAnvilCrushing(Level level, BlockPos pos, BlockState state, Entity entity) {
        AABB searchArea;
        List nearbyCows;
        FallingBlockEntity fallingBlock;
        if (entity instanceof FallingBlockEntity && ((fallingBlock = (FallingBlockEntity)entity).getBlockState().is(Blocks.ANVIL) || fallingBlock.getBlockState().is(Blocks.CHIPPED_ANVIL) || fallingBlock.getBlockState().is(Blocks.DAMAGED_ANVIL)) && !(nearbyCows = level.getEntitiesOfClass(FluidCow.class, searchArea = new AABB(pos).expandTowards(0.0, 2.0, 0.0))).isEmpty()) {
            FluidCowJarBlockEntity fluidCowJar;
            FluidCow cow = (FluidCow)((Object)nearbyCows.get(0));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FluidCowJarBlockEntity && (fluidCowJar = (FluidCowJarBlockEntity)blockEntity).addFluidCow(cow)) {
                cow.discard();
            }
        }
    }

    private void checkForAnvilAbove(Level level, BlockPos pos, BlockState state) {
        AABB searchArea;
        List nearbyCows;
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        if ((aboveState.is(Blocks.ANVIL) || aboveState.is(Blocks.CHIPPED_ANVIL) || aboveState.is(Blocks.DAMAGED_ANVIL)) && !(nearbyCows = level.getEntitiesOfClass(FluidCow.class, searchArea = new AABB(pos).expandTowards(0.0, 2.0, 0.0))).isEmpty()) {
            FluidCowJarBlockEntity fluidCowJar;
            FluidCow cow = (FluidCow)((Object)nearbyCows.get(0));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FluidCowJarBlockEntity && (fluidCowJar = (FluidCowJarBlockEntity)blockEntity).addFluidCow(cow)) {
                cow.discard();
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluidCowJarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : FluidCowJarBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)MFBlockEntities.FLUID_COW_JAR.get()), FluidCowJarBlockEntity::serverTick);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

