/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.block;

import com.portingdeadmods.moofluids.block.FluidCowJarBlock;
import com.portingdeadmods.moofluids.items.FluidCowJarBlockItem;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MFBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"moofluids");
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"moofluids");
    public static final DeferredHolder<Block, FluidCowJarBlock> FLUID_COW_JAR = MFBlocks.registerBlock("fluid_cow_jar", () -> new FluidCowJarBlock(BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(0.6f).noOcclusion().lightLevel(state -> (Integer)state.getValue((Property)FluidCowJarBlock.LIGHT_LEVEL))), FluidCowJarBlockItem::new);

    private static <T extends Block> DeferredHolder<Block, T> registerBlock(String name, Supplier<T> block) {
        return MFBlocks.registerBlock(name, block, BlockItem::new);
    }

    private static <T extends Block> DeferredHolder<Block, T> registerBlock(String name, Supplier<T> block, BiFunction<Block, Item.Properties, Item> blockItemFactory) {
        DeferredHolder toReturn = BLOCKS.register(name, block);
        MFBlocks.registerBlockItem(name, toReturn, blockItemFactory);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredHolder<Block, T> block, BiFunction<Block, Item.Properties, Item> blockItemFactory) {
        BLOCK_ITEMS.register(name, () -> (Item)blockItemFactory.apply((Block)block.get(), new Item.Properties()));
    }
}

