/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.compat.jei.FluidCowBreedingRecipe;
import com.portingdeadmods.moofluids.compat.jei.MFJeiPlugin;
import com.portingdeadmods.moofluids.entity.FluidCow;
import com.portingdeadmods.moofluids.entity.MFEntities;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Vector3f;

public class FluidCowBreedingCategory
extends AbstractRecipeCategory<FluidCowBreedingRecipe> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"moofluids", (String)"textures/gui/breeding.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable heartIcon;

    public FluidCowBreedingCategory(IGuiHelper guiHelper) {
        super(MFJeiPlugin.BREEDING_TYPE, (Component)Component.translatable((String)"jei.moofluids.category.breeding"), guiHelper.createDrawableItemStack(Items.WHEAT.getDefaultInstance()), 150, 70);
        this.background = guiHelper.createBlankDrawable(150, 70);
        this.icon = guiHelper.createDrawableItemStack(Items.WHEAT.getDefaultInstance());
        this.heartIcon = guiHelper.drawableBuilder(ResourceLocation.withDefaultNamespace((String)"textures/particle/heart.png"), 0, 0, 8, 8).setTextureSize(8, 8).build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidCowBreedingRecipe recipe, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.getParent1(), 1000));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.getParent2(), 1000));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.getResult(), 1000));
    }

    public void draw(FluidCowBreedingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level != null) {
            FluidCow parent1 = this.createCowWithFluid((Level)level, recipe.getParent1());
            FluidCow parent2 = this.createCowWithFluid((Level)level, recipe.getParent2());
            FluidCow result = this.createCowWithFluid((Level)level, recipe.getResult());
            this.renderCow(guiGraphics, (Entity)parent1, 25, 35, 15.0f);
            this.renderCow(guiGraphics, (Entity)parent2, 75, 35, 15.0f);
            this.heartIcon.draw(guiGraphics, 46, 20);
            this.renderCow(guiGraphics, (Entity)result, 50, 55, 15.0f);
            if (recipe.getSuccessChance() < 1.0f) {
                String chance = String.format("%.0f%%", Float.valueOf(recipe.getSuccessChance() * 100.0f));
                MutableComponent chanceText = Component.literal((String)(chance + " chance"));
                int textWidth = mc.font.width((FormattedText)chanceText);
                guiGraphics.drawString(mc.font, (Component)chanceText, 115 - textWidth / 2, 45, 0xFFAA00, true);
            }
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, FluidCowBreedingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.isMouseOverCow(mouseX, mouseY, 25, 35, 15.0f)) {
            this.addFluidTooltip(tooltip, recipe.getParent1());
        } else if (this.isMouseOverCow(mouseX, mouseY, 75, 35, 15.0f)) {
            this.addFluidTooltip(tooltip, recipe.getParent2());
        } else if (this.isMouseOverCow(mouseX, mouseY, 50, 55, 15.0f)) {
            this.addFluidTooltip(tooltip, recipe.getResult());
        }
    }

    private boolean isMouseOverCow(double mouseX, double mouseY, int cowX, int cowY, float scale) {
        double halfWidth = (double)scale * 0.8;
        double height = (double)scale * 1.6;
        return mouseX >= (double)cowX - halfWidth && mouseX <= (double)cowX + halfWidth && mouseY >= (double)cowY - height && mouseY <= (double)cowY;
    }

    private void addFluidTooltip(ITooltipBuilder tooltip, Fluid fluid) {
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        int color = FluidUtils.getFluidColor(fluid);
        MutableComponent fluidName = fluidStack.getHoverName().copy().setStyle(Style.EMPTY.withColor(color));
        tooltip.add((FormattedText)fluidName);
    }

    private FluidCow createCowWithFluid(Level level, Fluid fluid) {
        FluidCow cow = (FluidCow)MFEntities.FLUID_COW.get().create(level);
        if (cow != null) {
            cow.setFluid(BuiltInRegistries.FLUID.getKey((Object)fluid).toString());
            cow.setYRot(0.0f);
            cow.yRotO = 0.0f;
            cow.setXRot(0.0f);
            cow.xRotO = 0.0f;
            cow.yHeadRot = 0.0f;
            cow.yHeadRotO = 0.0f;
            cow.yBodyRot = 0.0f;
            cow.yBodyRotO = 0.0f;
        }
        return cow;
    }

    private void renderCow(GuiGraphics guiGraphics, Entity entity, int x, int y, float scale) {
        if (entity == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 50.0f);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher entityRenderDispatcher = mc.getEntityRenderDispatcher();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        entityRenderDispatcher.setRenderShadow(false);
        Vector3f light0 = new Vector3f(0.2f, 1.0f, -0.7f);
        Vector3f light1 = new Vector3f(-0.2f, 1.0f, 0.7f);
        light0.normalize();
        light1.normalize();
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        poseStack.popPose();
    }
}

