/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.entity;

import com.google.common.collect.ImmutableList;
import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.MFConfig;
import com.portingdeadmods.moofluids.Utils;
import com.portingdeadmods.moofluids.entity.MFEntities;
import com.portingdeadmods.moofluids.recipe.AlloyRecipe;
import com.portingdeadmods.moofluids.recipe.AlloyRecipeInput;
import com.portingdeadmods.moofluids.recipe.MFRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidCow
extends Cow {
    private static final EntityDataAccessor<String> FLUID_NAME = SynchedEntityData.defineId(FluidCow.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.defineId(FluidCow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CAN_BE_MILKED = SynchedEntityData.defineId(FluidCow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String TAG_FLUID = "FluidRegistryName";
    private static final String TAG_DELAY = "CurrentDelay";

    public FluidCow(EntityType<? extends Cow> type, Level worldIn) {
        super(type, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Cow.createAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(FLUID_NAME, (Object)BuiltInRegistries.FLUID.getKey((Object)Fluids.EMPTY).toString());
        pBuilder.define(DELAY, (Object)MFConfig.defaultMilkingCooldown);
        pBuilder.define(CAN_BE_MILKED, (Object)true);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        Fluid randomFluid;
        if (!pLevel.isClientSide() && (randomFluid = this.getRandomFluidForDimension(pLevel)) != null) {
            this.setFluid(Utils.idFromFluid(randomFluid));
            if (this.getDelay() < 0) {
                this.entityData.set(CAN_BE_MILKED, (Object)true);
            }
        }
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    public ResourceKey<LootTable> getDefaultLootTable() {
        return EntityType.COW.getDefaultLootTable();
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel worldIn, Animal animal, @Nullable AgeableMob newMob) {
        if (!worldIn.isClientSide() && newMob instanceof FluidCow) {
            FluidCow fluidCow = (FluidCow)newMob;
            if (animal instanceof FluidCow) {
                FluidCow fluidCowParent = (FluidCow)animal;
                Fluid parentFluid1 = this.getFluid();
                Fluid parentFluid2 = fluidCowParent.getFluid();
                AlloyRecipeInput input = new AlloyRecipeInput(List.of(parentFluid1, parentFluid2));
                RecipeManager recipeManager = worldIn.getRecipeManager();
                Optional alloyRecipe = recipeManager.getRecipeFor((RecipeType)MFRecipes.ALLOY_TYPE.get(), (RecipeInput)input, (Level)worldIn);
                if (alloyRecipe.isPresent()) {
                    RandomSource rnd = RandomSource.create();
                    float successChance = ((AlloyRecipe)((RecipeHolder)alloyRecipe.get()).value()).successChance();
                    if (rnd.nextFloat() < successChance) {
                        fluidCow.setFluid(Utils.idFromFluid(((AlloyRecipe)((RecipeHolder)alloyRecipe.get()).value()).output()));
                    } else {
                        int rndVal = Mth.nextInt((RandomSource)rnd, (int)0, (int)1);
                        fluidCow.setFluid(Utils.idFromFluid(rndVal == 0 ? parentFluid1 : parentFluid2));
                    }
                } else {
                    RandomSource rnd = RandomSource.create();
                    int rndVal = Mth.nextInt((RandomSource)rnd, (int)0, (int)1);
                    fluidCow.setFluid(Utils.idFromFluid(rndVal == 0 ? parentFluid1 : parentFluid2));
                }
                if (this.getDelay() < 0) {
                    fluidCow.getEntityData().set(CAN_BE_MILKED, (Object)false);
                }
            }
        }
        super.finalizeSpawnChildFromBreeding(worldIn, animal, newMob);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.getFluid() != Fluids.EMPTY && FluidUtils.isFluidBlacklisted(this.getFluid())) {
            this.entityData.set(FLUID_NAME, (Object)BuiltInRegistries.FLUID.getKey((Object)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.withDefaultNamespace((String)"milk")))).toString());
        }
        if (this.getDelay() > 0 && !this.canBeMilked()) {
            this.decreaseDelay();
        } else {
            this.setCanBeMilked(true);
            this.setDelay(MFConfig.defaultMilkingCooldown);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            if (this.canBeMilked() && this.getFluid() != Fluids.EMPTY && hand == InteractionHand.MAIN_HAND && player.getItemInHand(hand).getItem() == Items.BUCKET) {
                ItemStack stack = FluidUtil.getFilledBucket((FluidStack)new FluidStack(this.getFluid(), 1000));
                if (player.getItemInHand(hand).getCount() > 1 || player.isCreative()) {
                    int slotID = player.getInventory().getFreeSlot();
                    if (slotID != -1) {
                        player.getInventory().items.set(slotID, (Object)stack);
                        if (!player.isCreative()) {
                            player.getItemInHand(hand).shrink(1);
                        }
                        this.setCanBeMilked(false);
                    }
                } else {
                    player.setItemInHand(hand, stack);
                    this.setCanBeMilked(false);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(hand).getItem() == Items.WHEAT) {
                return super.mobInteract(player, hand);
            }
            if (MFConfig.milkCow && hand == InteractionHand.MAIN_HAND && player.getItemInHand(hand).getItem() == Items.BUCKET) {
                return super.mobInteract(player, hand);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean canBeMilked() {
        return (Boolean)this.entityData.get(CAN_BE_MILKED);
    }

    public void setCanBeMilked(boolean value) {
        this.entityData.set(CAN_BE_MILKED, (Object)value);
    }

    public void setFluid(String reg) {
        if (this.getFluid() == Fluids.EMPTY) {
            this.entityData.set(FLUID_NAME, (Object)reg);
        }
    }

    public Fluid getFluid() {
        if (((String)this.entityData.get(FLUID_NAME)).equals(BuiltInRegistries.FLUID.getKey((Object)Fluids.EMPTY).toString())) {
            return Fluids.EMPTY;
        }
        Fluid fluid = Utils.get((String)this.entityData.get(FLUID_NAME));
        return fluid != null ? fluid : Fluids.EMPTY;
    }

    public FluidStack getFluidStack() {
        return new FluidStack(this.getFluid(), 1000);
    }

    public int getDelay() {
        return (Integer)this.entityData.get(DELAY);
    }

    public void setDelay(int delay) {
        this.entityData.set(DELAY, (Object)delay);
    }

    public void decreaseDelay() {
        this.setDelay(this.getDelay() - 1);
    }

    @Nullable
    public Fluid getRandomFluidForDimension(ServerLevelAccessor levelAccessor) {
        if (!(levelAccessor instanceof ServerLevel)) {
            return this.getRandomFluid();
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        ResourceKey currentDimension = serverLevel.dimension();
        ResourceLocation currentDimensionId = currentDimension.location();
        ArrayList<Fluid> availableFluids = new ArrayList<Fluid>();
        ImmutableList<Fluid> allFluids = Utils.getFluids();
        for (Fluid fluid : allFluids) {
            ResourceLocation fluidId = BuiltInRegistries.FLUID.getKey((Object)fluid);
            if (MFConfig.dimensionSpawnRestrictions.containsKey(fluidId)) {
                ResourceLocation allowedDimension = MFConfig.dimensionSpawnRestrictions.get(fluidId);
                if (!allowedDimension.equals((Object)currentDimensionId)) continue;
                availableFluids.add(fluid);
                continue;
            }
            availableFluids.add(fluid);
        }
        if (availableFluids.isEmpty()) {
            return null;
        }
        RandomSource rnd = RandomSource.create();
        int rndVal = Mth.nextInt((RandomSource)rnd, (int)0, (int)(availableFluids.size() - 1));
        return (Fluid)availableFluids.get(rndVal);
    }

    @Nullable
    public Fluid getRandomFluid() {
        ImmutableList<Fluid> fluids = Utils.getFluids();
        if (fluids.isEmpty()) {
            return null;
        }
        RandomSource rnd = RandomSource.create();
        int rndVal = Mth.nextInt((RandomSource)rnd, (int)0, (int)(fluids.size() - 1));
        return (Fluid)fluids.get(rndVal);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt(TAG_DELAY, this.getDelay());
        if (this.getFluid() != Fluids.EMPTY && BuiltInRegistries.FLUID.containsValue((Object)this.getFluid())) {
            compound.putString(TAG_FLUID, BuiltInRegistries.FLUID.getKey((Object)this.getFluid()).toString());
        } else {
            compound.putString(TAG_FLUID, BuiltInRegistries.FLUID.getKey((Object)Fluids.EMPTY).toString());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFluid(compound.getString(TAG_FLUID));
        this.setDelay(compound.getInt(TAG_DELAY));
    }

    @Nullable
    public FluidCow getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        return (FluidCow)MFEntities.FLUID_COW.get().create((Level)p_148890_);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(Items.WHEAT);
    }
}

