/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class AdditionalItemPlacementsAPI {
    @Deprecated(forRemoval=true)
    public static void addRegistration(Consumer<Event> eventConsumer) {
        Moonlight.assertInitPhase();
        PlatHelper.addCommonSetup(() -> eventConsumer.accept(AdditionalItemPlacementsAPI::registerPlacement));
    }

    public static void registerPlacement(Item target, AdditionalItemPlacement placement) {
        IExtendedItem ei = (IExtendedItem)target;
        AdditionalItemPlacement old = ei.moonlight$getAdditionalBehavior();
        if (old != null) {
            AdditionalItemPlacementsAPI.unregisterPlacement(target);
            Moonlight.LOGGER.warn("Overriding existing additional placement behavior for item {}, placement {}", (Object)target, (Object)old);
        }
        ei.moonlight$setAdditionalBehavior(placement);
        Block placedBlock = placement.getPlacedBlock();
        if (target == Items.AIR || placedBlock == Blocks.AIR) {
            throw new AssertionError((Object)("Invalid item or block for additional placement: block = " + String.valueOf(placedBlock) + ", item = " + String.valueOf(target)));
        }
        Item.BY_BLOCK.put(placedBlock, target);
        placedBlock.item = null;
    }

    public static void registerSimplePlacement(Item target, Block toPlace) {
        AdditionalItemPlacementsAPI.registerPlacement(target, new AdditionalItemPlacement(toPlace));
    }

    public static void unregisterPlacement(Item target) {
        IExtendedItem ei = (IExtendedItem)target;
        AdditionalItemPlacement old = ei.moonlight$getAdditionalBehavior();
        if (old != null) {
            ei.moonlight$setAdditionalBehavior(null);
            Block placedBlock = old.getPlacedBlock();
            if (placedBlock.item == target) {
                Item.BY_BLOCK.remove(placedBlock);
                placedBlock.item = null;
            }
        }
    }

    @Nullable
    public static AdditionalItemPlacement getBehavior(Item item) {
        return ((IExtendedItem)item).moonlight$getAdditionalBehavior();
    }

    public static boolean hasBehavior(Item item) {
        return AdditionalItemPlacementsAPI.getBehavior(item) != null;
    }

    @Deprecated(forRemoval=true)
    public static interface Event {
        public void register(Item var1, AdditionalItemPlacement var2);

        default public void registerSimple(Item target, Block toPlace) {
            this.register(target, new AdditionalItemPlacement(toPlace));
        }
    }
}

