/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ae;

import appeng.block.IOwnerAwareBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.tom.morewires.SimpleWireTypeDefinition;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AEItemBlock
extends BlockItem {
    private final SimpleWireTypeDefinition<?> def;

    public AEItemBlock(Block id, SimpleWireTypeDefinition<?> def) {
        super(id, new Item.Properties());
        this.def = def;
    }

    public InteractionResult place(BlockPlaceContext context) {
        InteractionResult result = super.place(context);
        if (!result.consumesAction()) {
            return result;
        }
        BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
        if (be instanceof IOwnerAwareBlockEntity) {
            IOwnerAwareBlockEntity oa = (IOwnerAwareBlockEntity)be;
            oa.setOwner(context.getPlayer());
        }
        return result;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState newState) {
        Block b = newState.getBlock();
        if (b instanceof IEBaseBlock) {
            IEBaseBlock ieBlock = (IEBaseBlock)b;
            if (!ieBlock.canIEBlockBePlaced(newState, context)) {
                return false;
            }
            boolean ret = super.placeBlock(context, newState);
            if (ret) {
                ieBlock.onIEBlockPlacedBy(context, newState);
            }
            return ret;
        }
        return super.placeBlock(context, newState);
    }

    public void appendHoverText(ItemStack p_40572_, Item.TooltipContext p_40573_, List<Component> p_40574_, TooltipFlag p_40575_) {
        super.appendHoverText(p_40572_, p_40573_, p_40574_, p_40575_);
        this.def.appendHoverTextConnector(null, p_40572_, p_40573_, p_40574_, p_40575_);
    }
}

