/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.rs;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.rs.RSNetworkHandler;
import com.tom.morewires.tile.IOnCable;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RSConnectorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements IOnCable.IOnCableConnector {
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;

    protected RSConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, (AbstractNetworkNode)new SimpleNetworkNode(0L));
    }

    protected InWorldNetworkNodeContainer createMainContainer(SimpleNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer((BlockEntity)this, (NetworkNode)networkNode).connectionStrategy((ConnectionStrategy)new ColoredConnectionStrategy(() -> ((RSConnectorBlockEntity)this).getBlockState(), this.getBlockPos()){

            public void addOutgoingConnections(ConnectionSink sink) {
                RSNetworkHandler net;
                Direction direction = RSConnectorBlockEntity.this.getFacing();
                sink.tryConnectInSameDimension(this.origin.relative(direction), direction.getOpposite());
                LocalWireNetwork local = RSConnectorBlockEntity.this.globalNet.getNullableLocalNet(new ConnectionPoint(RSConnectorBlockEntity.this.worldPosition, 0));
                if (local != null && (net = (RSNetworkHandler)local.getHandler(MoreImmersiveWires.RS_WIRE.simple().NET_ID, RSNetworkHandler.class)) != null) {
                    net.addConnections(sink);
                }
            }

            public boolean canAcceptIncomingConnection(Direction incomingDirection, BlockState connectingState) {
                return incomingDirection == RSConnectorBlockEntity.this.getFacing();
            }
        }).build();
    }

    public BlockState getState() {
        return this.getBlockState();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.worldPosition, 0));
        if (local != null && !local.getConnections(this.worldPosition).isEmpty()) {
            return false;
        }
        return cableType == MoreImmersiveWires.RS_WIRE.simple().wireType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.setChanged();
    }

    public BlockPos getPosition() {
        return this.worldPosition;
    }

    @Override
    public Level getLevelNonnull() {
        return this.level;
    }

    public void setLevel(Level worldIn) {
        super.setLevel(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.level);
        this.isUnloaded = false;
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.level, (IImmersiveConnectable)this);
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.RS_WIRE.simple().NET_ID);
    }

    public Component getName() {
        return ((Block)MoreImmersiveWires.RS_WIRE.simple().CONNECTOR.get()).getName();
    }

    public GlobalPos getGlobalPos() {
        return new GlobalPos(this.level.dimension(), this.worldPosition);
    }

    public void networkChanged() {
        this.containers.update(this.level);
    }
}

