/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.OfferExtension;
import com.almostreliable.morejs.mixin.villager.MerchantOfferAccessor;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.world.item.trading.MerchantOffer;

public class MerchantOfferCodecPatch
implements Codec<MerchantOffer> {
    public static final String KEY = "morejs$isDisabled";
    private final Codec<MerchantOffer> codec;

    public static void patch() {
        MerchantOfferCodecPatch patch = new MerchantOfferCodecPatch((Codec<MerchantOffer>)MerchantOffer.CODEC);
        MerchantOfferAccessor.morejs$setCodec(patch);
    }

    public MerchantOfferCodecPatch(Codec<MerchantOffer> codec) {
        this.codec = codec;
    }

    public <T> DataResult<Pair<MerchantOffer, T>> decode(DynamicOps<T> ops, T input) {
        return this.codec.decode(ops, input).map(pair -> {
            MerchantOffer offer = (MerchantOffer)pair.getFirst();
            DataResult isDisabledResult = ops.get(input, KEY);
            isDisabledResult.flatMap(arg_0 -> ((DynamicOps)ops).getBooleanValue(arg_0)).ifSuccess(disabled -> ((OfferExtension)offer).morejs$setDisabled((boolean)disabled));
            return pair;
        });
    }

    public <T> DataResult<T> encode(MerchantOffer offer, DynamicOps<T> ops, T prefix) {
        return this.codec.encode((Object)offer, ops, prefix).map(data -> {
            boolean isDisabled = ((OfferExtension)offer).morejs$isDisabled();
            Object isDisabledData = ops.createBoolean(isDisabled);
            return ops.set(data, KEY, isDisabledData);
        });
    }
}

