/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.almostreliable.morejs.util.BlockPosFinder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class TreasureMapTrade
extends TransformableTrade<TreasureMapTrade> {
    protected final BlockPosFinder blockPosFinder;
    @Nullable
    protected Component displayName;
    protected Holder<MapDecorationType> destinationType = MapDecorationTypes.RED_X;
    private boolean renderBiomePreviewMap = true;
    private byte mapViewScale = (byte)2;

    public TreasureMapTrade(TradeItem[] inputs, BlockPosFinder blockPosFinder) {
        super(inputs);
        this.blockPosFinder = blockPosFinder;
    }

    public TreasureMapTrade displayName(Component name) {
        this.displayName = name;
        return this;
    }

    public TreasureMapTrade marker(Holder<MapDecorationType> type) {
        this.destinationType = type;
        return this;
    }

    public TreasureMapTrade noPreview() {
        this.renderBiomePreviewMap = false;
        return this;
    }

    public TreasureMapTrade scale(byte scale) {
        this.mapViewScale = scale;
        return this;
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity trader, RandomSource random) {
        Level level = trader.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = this.blockPosFinder.findPosition(level2, trader);
            if (pos == null) {
                return null;
            }
            ItemStack map = MapItem.create((Level)level2, (int)pos.getX(), (int)pos.getZ(), (byte)this.mapViewScale, (boolean)true, (boolean)true);
            if (this.renderBiomePreviewMap) {
                MapItem.renderBiomePreviewMap((ServerLevel)level2, (ItemStack)map);
            }
            MapItemSavedData.addTargetDecoration((ItemStack)map, (BlockPos)pos, (String)"+", this.destinationType);
            if (this.displayName != null) {
                map.set(DataComponents.CUSTOM_NAME, (Object)this.displayName);
            }
            return this.createOffer(map, random);
        }
        return null;
    }
}

