/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class HexidecrubrometerBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final EnumProperty<AttachFace> READING_FACE = BlockStateProperties.ATTACH_FACE;
    public static final EnumProperty<Direction> ROTATION = BlockStateProperties.HORIZONTAL_FACING;

    public HexidecrubrometerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue(READING_FACE, (Comparable)AttachFace.WALL)).setValue(ROTATION, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER, READING_FACE, ROTATION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction attachDirection = context.getNearestLookingDirection();
        Direction horizontalDirectionAwayFromPlayer = context.getHorizontalDirection();
        AttachFace attachFace = attachDirection == Direction.DOWN ? AttachFace.FLOOR : (attachDirection == Direction.UP ? AttachFace.CEILING : AttachFace.WALL);
        Direction readingDirection = HexidecrubrometerBlock.getReadingDirection(attachFace, horizontalDirectionAwayFromPlayer);
        int power = HexidecrubrometerBlock.getInputValue(world, pos, readingDirection);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(READING_FACE, (Comparable)attachFace)).setValue(ROTATION, (Comparable)horizontalDirectionAwayFromPlayer.getOpposite())).setValue((Property)POWER, (Comparable)Integer.valueOf(power));
    }

    @Deprecated
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.getBlock() != this) {
            int oldPower = (Integer)state.getValue((Property)POWER);
            int newPower = HexidecrubrometerBlock.getInputValue(worldIn, pos, state);
            if (newPower != oldPower) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower)));
            }
        }
        super.onPlace(state, worldIn, pos, oldState, isMoving);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (pos.relative(HexidecrubrometerBlock.getReadingDirection(state)).equals((Object)neighbor)) {
                state.handleNeighborChanged((Level)serverLevel, pos, world.getBlockState(neighbor).getBlock(), neighbor, false);
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        int oldValue;
        int newValue = HexidecrubrometerBlock.getInputValue(world, pos, state);
        if (newValue != (oldValue = ((Integer)state.getValue((Property)POWER)).intValue())) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newValue)));
        }
    }

    public static int getInputValue(Level world, BlockPos pos, BlockState state) {
        Direction direction = HexidecrubrometerBlock.getReadingDirection(state);
        return HexidecrubrometerBlock.getInputValue(world, pos, direction);
    }

    public static int getInputValue(Level world, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.relative(direction);
        BlockState neighborState = world.getBlockState(neighborPos);
        int comparatorPower = neighborState.getAnalogOutputSignal(world, neighborPos);
        int canonicalRedstonePower = world.getSignal(neighborPos, direction);
        int redstonePower = canonicalRedstonePower > 0 ? canonicalRedstonePower : (neighborState.getBlock() instanceof RedStoneWireBlock ? (Integer)neighborState.getValue((Property)BlockStateProperties.POWER) : 0);
        return Math.max(redstonePower, comparatorPower);
    }

    public static Direction getReadingDirection(BlockState state) {
        AttachFace face = (AttachFace)state.getValue(READING_FACE);
        Direction directionAwayFromDisplay = ((Direction)state.getValue(ROTATION)).getOpposite();
        return HexidecrubrometerBlock.getReadingDirection(face, directionAwayFromDisplay);
    }

    public static Direction getReadingDirection(AttachFace attachFace, Direction directionAwayFromDisplay) {
        switch (attachFace) {
            case CEILING: {
                return Direction.UP;
            }
            case FLOOR: {
                return Direction.DOWN;
            }
            case WALL: {
                return directionAwayFromDisplay;
            }
        }
        return Direction.DOWN;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && side.getOpposite() == HexidecrubrometerBlock.getReadingDirection(state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(ROTATION, (Comparable)rot.rotate((Direction)state.getValue(ROTATION)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(ROTATION, (Comparable)mirror.mirror((Direction)state.getValue(ROTATION)));
    }
}

