/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.mojang.math.Transformation;
import net.minecraft.Util;
import net.minecraft.client.resources.model.ModelState;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FaceRotation
implements ModelState {
    public static final FaceRotation[] FACE_ROTATIONS = (FaceRotation[])Util.make(() -> {
        FaceRotation[] result = new FaceRotation[24];
        int[] r0231 = new int[]{0, 180, 270, 90};
        int[] r2013 = new int[]{180, 0, 90, 270};
        int[] r1302 = new int[]{90, 270, 0, 180};
        int[] r3102 = new int[]{270, 90, 0, 180};
        int[] r2031 = new int[]{180, 0, 270, 90};
        int[] r0213 = new int[]{0, 180, 90, 270};
        for (int side = 0; side < 6; ++side) {
            for (int subSide = 0; subSide < 4; ++subSide) {
                int y;
                int x;
                int n = side == 0 ? 0 : (side == 1 ? 180 : (side == 2 ? 270 : (x = side == 3 ? 90 : 0)));
                int n2 = side == 0 ? r0231[subSide] : (side == 1 ? r2013[subSide] : (side == 4 ? r1302[subSide] : (y = side == 5 ? r3102[subSide] : 0)));
                int z = side == 2 ? r2031[subSide] : (side == 3 ? r0213[subSide] : (side == 4 ? 90 : (side == 5 ? 270 : 0)));
                result[side * 4 + subSide] = new FaceRotation(x, y, z);
            }
        }
        return result;
    });
    private final Transformation transformation;

    public static FaceRotation getFaceRotation(int side, int subSide) {
        return FACE_ROTATIONS[side * 4 + subSide];
    }

    FaceRotation(int x, int y, int z) {
        float d2r = (float)Math.PI / 180;
        Quaternionf q = new Quaternionf();
        q.setAngleAxis((float)(-z) * d2r, 0.0f, 0.0f, 1.0f);
        q.mul((Quaternionfc)new Quaternionf().setAngleAxis((float)(-y) * d2r, 0.0f, 1.0f, 0.0f));
        q.mul((Quaternionfc)new Quaternionf().setAngleAxis((float)(-x) * d2r, 1.0f, 0.0f, 0.0f));
        this.transformation = new Transformation((Vector3f)null, q, (Vector3f)null, (Quaternionf)null);
    }

    public Transformation getRotation() {
        return this.transformation;
    }
}

