/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.soldering;

import commoble.morered.MoreRed;
import commoble.morered.soldering.SolderingMenu;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SolderingRecipeButtonPacket(ResourceLocation recipeId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SolderingRecipeButtonPacket> TYPE = new CustomPacketPayload.Type(MoreRed.getModRL("soldering_recipe_button"));
    public static final StreamCodec<ByteBuf, SolderingRecipeButtonPacket> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(SolderingRecipeButtonPacket::new, SolderingRecipeButtonPacket::recipeId);

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> this.handleThreadsafe(context));
    }

    public void handleThreadsafe(IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AbstractContainerMenu container = player2.containerMenu;
            if (container instanceof SolderingMenu) {
                SolderingMenu menu = (SolderingMenu)container;
                menu.onPlayerChoseRecipe(this.recipeId);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

