/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.MechanicalChamberBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringPartialModels;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MechanicalChamberRenderer
extends KineticBlockEntityRenderer<MechanicalChamberBlockEntity> {
    public MechanicalChamberRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void renderSafe(MechanicalChamberBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.renderSafe((KineticBlockEntity)blockEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        ItemStackHandler handler = blockEntity.itemStackHandler;
        if (handler == null) {
            OccultEngineering.LOGGER.warn("itemStackHandler is null");
            return;
        }
        ItemStack stack = handler.getStackInSlot(0);
        long time = blockEntity.getLevel().getGameTime();
        Direction facing = Direction.UP;
        poseStack.pushPose();
        poseStack.pushPose();
        double offset = Math.sin(((float)(time - blockEntity.lastChangeTime) + partialTicks) / 16.0f) * 0.5 + 0.5;
        double fixedOffset = 0.2;
        double yOffset = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -(offset /= 7.0) - fixedOffset;
        poseStack.translate(0.5, 0.15 + yOffset, 0.5);
        long systemTime = System.currentTimeMillis();
        float angle = systemTime / 16L % 360L;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        float scale = 0.5f;
        poseStack.scale(scale, scale, scale);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = itemRenderer.getModel(stack, blockEntity.getLevel(), null, 0);
        itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, model);
        poseStack.popPose();
        poseStack.mulPose(facing.getRotation());
        poseStack.popPose();
    }

    protected SuperByteBuffer getRotatedModel(MechanicalChamberBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)OccultEngineeringPartialModels.SHAFT_SPLIT, (BlockState)state, (Direction)Direction.UP);
    }
}

