/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber;

import com.klikli_dev.occultism.common.ritual.CraftMinerSpiritRitual;
import com.klikli_dev.occultism.common.ritual.CraftRitual;
import com.klikli_dev.occultism.common.ritual.CraftWithSpiritNameRitual;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.IRitualProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualProcessorBehaviour
extends BlockEntityBehaviour
implements IRitualProcessor {
    public static BehaviourType<RitualProcessorBehaviour> TYPE = new BehaviourType();
    @Nullable
    public RecipeHolder<RitualRecipe> currentRitualRecipe;
    @Nullable
    public ResourceLocation currentRitualRecipeId;
    @Nullable
    public List<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
    @NotNull
    public List<ItemStack> consumedIngredients = new ArrayList<ItemStack>();
    public int tier = 1;
    public int currentTime = 0;
    public Supplier<ItemStackHandler> itemStackHandlerGetter;
    public Supplier<Integer> ritualSpeedMultiplier;

    public RitualProcessorBehaviour(SmartBlockEntity be, Supplier<ItemStackHandler> itemStackHandlerGetter, Supplier<Integer> ritualSpeedMultiplier) {
        super(be);
        this.itemStackHandlerGetter = itemStackHandlerGetter;
        this.ritualSpeedMultiplier = ritualSpeedMultiplier;
    }

    @Override
    public void tick() {
        super.tick();
        Optional<RecipeHolder<RitualRecipe>> maybeRecipe = this.getRitualRecipe();
        Level level = this.blockEntity.getLevel();
        if (level == null || level.isClientSide || maybeRecipe.isEmpty()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RecipeHolder<RitualRecipe> recipe = maybeRecipe.get();
        if (this.remainingAdditionalIngredients == null) {
            this.restoreRemainingAdditionalIngredients();
            if (this.remainingAdditionalIngredients == null) {
                return;
            }
        }
        ItemStackHandler handler = this.itemStackHandlerGetter.get();
        if (!this.ritualIsValid((RitualRecipe)recipe.value(), level, this.blockEntity.getBlockPos(), handler.getStackInSlot(0), this.remainingAdditionalIngredients)) {
            this.stopRitual(false);
            return;
        }
        if (level.random.nextInt(16) == 0) {
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)this.getPos().getX() + 0.5 + level.random.nextGaussian() / 3.0, (double)this.getPos().getY() + 0.5 + level.random.nextGaussian() / 3.0, (double)this.getPos().getZ() + 0.5 + level.random.nextGaussian() / 3.0, 5, 0.0, 0.0, 0.0, 0.0);
        }
        if (level.getGameTime() % 5L == 0L) {
            if (!this.remainingAdditionalIngredients.isEmpty()) {
                ((RitualRecipe)recipe.value()).getRitual().markNextIngredient(level, this.getPos(), this.remainingAdditionalIngredients.getFirst(), this.getTier());
            } else {
                double time = (double)level.getGameTime() / 20.0;
                double sinAdjusted = Math.sin(time) * 0.3;
                double cosAdjusted = Math.cos(time) * 0.3;
                Vec3 centre = this.getPos().getCenter();
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)OccultismParticles.SPIRIT_FIRE_FLAME.get()), centre.x + cosAdjusted, centre.y + 0.2 + cosAdjusted, centre.z + sinAdjusted, 1, 0.0, 0.0, 0.0, 0.003);
            }
        }
        if (level.getGameTime() % 20L == 0L) {
            this.currentTime += Math.abs(this.ritualSpeedMultiplier.get());
        }
        if (!((RitualRecipe)recipe.value()).getRitual().consumeAdditionalIngredients(level, this.getPos(), this.remainingAdditionalIngredients, this.currentTime, this.consumedIngredients)) {
            this.stopRitual(false);
            return;
        }
        if (((RitualRecipe)recipe.value()).getDuration() >= 0 && this.currentTime >= ((RitualRecipe)recipe.value()).getDuration()) {
            this.stopRitual(true);
        }
    }

    protected void restoreRemainingAdditionalIngredients() {
        Optional<RecipeHolder<RitualRecipe>> ritualRecipe = this.getRitualRecipe();
        if (ritualRecipe.isEmpty() || this.blockEntity.getLevel() == null) {
            this.remainingAdditionalIngredients = null;
            return;
        }
        RitualRecipe recipe = (RitualRecipe)ritualRecipe.get().value();
        this.remainingAdditionalIngredients = !this.consumedIngredients.isEmpty() ? Ritual.getRemainingAdditionalIngredients((List)recipe.getIngredients(), this.consumedIngredients) : new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getIngredients());
    }

    public boolean ritualIsValid(RitualRecipe recipe, Level level, BlockPos goldenBowlPosition, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return recipe.getPentacle() != null && recipe.getActivationItem().test(activationItem) && recipe.getRitual().areAdditionalIngredientsFulfilled(level, goldenBowlPosition, remainingAdditionalIngredients) && recipe.getPentacle().validate(level, goldenBowlPosition) != null;
    }

    @Override
    public void startRitual(@Nullable ServerPlayer player, ItemStack activationItem, RecipeHolder<RitualRecipe> ritualRecipe) {
        Level level = this.blockEntity.getLevel();
        if (level == null) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        if (((RitualRecipe)ritualRecipe.value()).getEntityToSummon() != null || ((RitualRecipe)ritualRecipe.value()).requiresItemUse() || ((RitualRecipe)ritualRecipe.value()).requiresSacrifice()) {
            return;
        }
        this.currentRitualRecipe = ritualRecipe;
        this.currentTime = 0;
        this.consumedIngredients.clear();
        this.remainingAdditionalIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)((RitualRecipe)ritualRecipe.value()).getIngredients());
        this.blockDirty();
    }

    @Override
    public void stopRitual(boolean ritualCompleted) {
        Level level = this.blockEntity.getLevel();
        if (level == null) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        Optional<RecipeHolder<RitualRecipe>> maybeRecipe = this.getRitualRecipe();
        if (maybeRecipe.isPresent()) {
            RecipeHolder<RitualRecipe> recipe = maybeRecipe.get();
            ItemStackHandler itemStackHandler = this.itemStackHandlerGetter.get();
            if (ritualCompleted) {
                ItemStack activationItem = itemStackHandler.getStackInSlot(0);
                if (((RitualRecipe)recipe.value()).getRitual() instanceof CraftRitual) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ItemStack result = ((RitualRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    itemStackHandler.setStackInSlot(0, result);
                } else if (((RitualRecipe)recipe.value()).getRitual() instanceof CraftWithSpiritNameRitual) {
                    ItemStack copy = activationItem.copy();
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ItemStack result = ((RitualRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    ItemNBTUtil.setBoundSpiritName((ItemStack)result, (String)ItemNBTUtil.getBoundSpiritName((ItemStack)copy));
                    itemStackHandler.setStackInSlot(0, result);
                } else if (((RitualRecipe)recipe.value()).getRitual() instanceof CraftMinerSpiritRitual) {
                    ItemStack copy = activationItem.copy();
                    activationItem.shrink(1);
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    ItemStack result = ((RitualRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    result.getItem().onCraftedBy(result, level, null);
                    ItemNBTUtil.setBoundSpiritName((ItemStack)result, (String)ItemNBTUtil.getBoundSpiritName((ItemStack)copy));
                    itemStackHandler.setStackInSlot(0, result);
                } else {
                    ((RitualRecipe)recipe.value()).getRitual().finish(level, this.getPos(), null, null, activationItem);
                }
            } else {
                Containers.dropItemStack((Level)level, (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), (ItemStack)itemStackHandler.extractItem(0, 1, false));
            }
        }
        this.currentRitualRecipe = null;
        this.currentRitualRecipeId = null;
        this.currentTime = 0;
        if (this.remainingAdditionalIngredients != null) {
            this.remainingAdditionalIngredients.clear();
        }
        this.consumedIngredients.clear();
        this.blockDirty();
    }

    @Override
    public Optional<RecipeHolder<RitualRecipe>> getRitualRecipe() {
        if (this.currentRitualRecipeId != null && this.blockEntity.getLevel() != null) {
            Level level = Objects.requireNonNull(this.blockEntity.getLevel());
            Optional recipe = level.getRecipeManager().byKey(this.currentRitualRecipeId);
            Optional<RecipeHolder> result = recipe.filter(r -> r.value() instanceof RitualRecipe).map(r -> r);
            result.ifPresent(ritualRecipeRecipeHolder -> {
                this.currentRitualRecipe = ritualRecipeRecipeHolder;
            });
            this.currentRitualRecipeId = null;
        }
        return Optional.ofNullable(this.currentRitualRecipe);
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        this.consumedIngredients.clear();
        this.itemStackHandlerGetter.get().deserializeNBT(registries, nbt.getCompound("inventory"));
        if (this.currentRitualRecipeId != null || this.getRitualRecipe().isPresent()) {
            if (nbt.contains("consumedIngredients")) {
                ListTag list = nbt.getList("consumedIngredients", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)list.getCompound(i));
                    this.consumedIngredients.add(stack);
                }
            }
            this.restoreRemainingAdditionalIngredients();
        }
        if (nbt.contains("currentRitual")) {
            this.currentRitualRecipeId = ResourceLocation.parse((String)nbt.getString("currentRitual"));
        }
        this.currentTime = nbt.getInt("currentTime");
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.put("inventory", (Tag)this.itemStackHandlerGetter.get().serializeNBT(registries));
        if (this.isRitualActive()) {
            RecipeHolder<RitualRecipe> recipe = this.currentRitualRecipe;
            assert (recipe != null);
            nbt.putString("currentRitual", recipe.id().toString());
            if (!this.consumedIngredients.isEmpty()) {
                ListTag list = new ListTag();
                for (ItemStack stack : this.consumedIngredients) {
                    list.add((Object)stack.saveOptional(registries));
                }
                nbt.put("consumedIngredients", (Tag)list);
            }
        }
        nbt.putInt("currentTime", this.currentTime);
        super.write(nbt, registries, clientPacket);
    }

    @Override
    public boolean isRitualActive() {
        if (this.blockEntity.getLevel() == null) {
            return false;
        }
        if (this.blockEntity.getLevel().isClientSide) {
            return this.currentRitualRecipe != null;
        }
        return this.getRitualRecipe().isPresent();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void blockDirty() {
        this.blockEntity.notifyUpdate();
        if (this.blockEntity.getLevel() != null) {
            this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 3);
        }
    }
}

