/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.display;

import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.MechanicalChamberBlockEntity;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.RitualProcessorBehaviour;
import java.util.Optional;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class RitualCompletionDisplaySource
extends PercentOrProgressBarDisplaySource {
    @Nullable
    protected Float getProgress(DisplayLinkContext context) {
        BlockEntity be = context.getSourceBlockEntity();
        if (!(be instanceof MechanicalChamberBlockEntity)) {
            return Float.valueOf(0.0f);
        }
        MechanicalChamberBlockEntity mcb = (MechanicalChamberBlockEntity)be;
        RitualProcessorBehaviour ritualBehaviour = (RitualProcessorBehaviour)mcb.getBehaviour(RitualProcessorBehaviour.TYPE);
        if (ritualBehaviour == null) {
            return Float.valueOf(0.0f);
        }
        if (!ritualBehaviour.isRitualActive()) {
            return Float.valueOf(0.0f);
        }
        Optional<RecipeHolder<RitualRecipe>> recipe = ritualBehaviour.getRitualRecipe();
        return recipe.map(ritualRecipeRecipeHolder -> Float.valueOf((float)ritualBehaviour.currentTime / (float)((RitualRecipe)ritualRecipeRecipeHolder.value()).getDuration())).orElse(Float.valueOf(0.0f));
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return context.sourceConfig().getInt("Mode") == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(CreateLang.translatedOptions((String)"display_source.fill_level", (String[])new String[]{"percent", "progress_bar"})).titled(CreateLang.translateDirect((String)"display_source.fill_level.display", (Object[])new Object[0])), "Mode");
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

