/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_pulverizer.PulverizerBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PulverizerBlock
extends HorizontalKineticBlock
implements IBE<PulverizerBlockEntity> {
    private static final VoxelShaper SHAPE = new AllShapes.Builder(Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)13.0)).add(5.0, 2.0, 3.0, 11.0, 11.0, 10.0).forHorizontal(Direction.SOUTH);

    public PulverizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE.get((Direction)state.getValue(HORIZONTAL_FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)Objects.requireNonNullElseGet(preferred, () -> ((BlockPlaceContext)context).getHorizontalDirection()).getOpposite());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean hasHandInteraction;
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        PulverizerBlockEntity be = (PulverizerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean bl = hasHandInteraction = player.getItemInHand(hand).isEmpty() || be.canProcess(player.getItemInHand(hand));
        if (!hasHandInteraction) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, pulverizer -> {
            ItemStack mainHandItem = player.getItemInHand(hand);
            if (mainHandItem.isEmpty()) {
                int slot;
                boolean outputEmpty = true;
                ItemStackHandler inv = pulverizer.outputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemStack stackInSlot = inv.getStackInSlot(slot);
                    if (!stackInSlot.isEmpty()) {
                        outputEmpty = false;
                    }
                    player.getInventory().placeItemBackInInventory(stackInSlot);
                    inv.setStackInSlot(slot, ItemStack.EMPTY);
                }
                if (outputEmpty) {
                    inv = pulverizer.inputInv;
                    for (slot = 0; slot < inv.getSlots(); ++slot) {
                        player.getInventory().placeItemBackInInventory(inv.getStackInSlot(slot));
                        inv.setStackInSlot(slot, ItemStack.EMPTY);
                    }
                }
            } else if (pulverizer.inputInv.getStackInSlot(0).isEmpty()) {
                player.setItemInHand(hand, pulverizer.inputInv.insertItem(0, mainHandItem, false));
            }
            pulverizer.notifyUpdate();
        });
        return ItemInteractionResult.SUCCESS;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite();
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.getValue(HORIZONTAL_FACING)).getAxis();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public Class<PulverizerBlockEntity> getBlockEntityClass() {
        return PulverizerBlockEntity.class;
    }

    public BlockEntityType<? extends PulverizerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)OccultEngineeringBlockEntities.MECHANICAL_PULVERIZER.get();
    }
}

