/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.pucalith;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import io.github.irishgreencitrus.occultengineering.content.block.pucalith.PucalithBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringGuiTextures;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringMenuTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class PucalithMenu
extends MenuBase<PucalithBlockEntity> {
    private Slot inputClipboard;
    private Slot outputClipboard;
    private Slot inputSchematic;
    private Slot outputSchematic;

    protected PucalithMenu(MenuType<?> type, int id, Inventory inv, PucalithBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public PucalithMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public static PucalithMenu create(int id, Inventory inv, PucalithBlockEntity be) {
        return new PucalithMenu((MenuType)OccultEngineeringMenuTypes.PUCALITH.get(), id, inv, be);
    }

    protected PucalithBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof PucalithBlockEntity) {
            PucalithBlockEntity be = (PucalithBlockEntity)blockEntity;
            be.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return be;
        }
        return null;
    }

    protected void initAndReadInventory(PucalithBlockEntity pucalithBlockEntity) {
    }

    protected void addSlots() {
        int slot = 0;
        this.inputSchematic = new SlotItemHandler(this, (IItemHandler)((PucalithBlockEntity)((Object)this.contentHolder)).inventory, slot++, 55, 60){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return OccultEngineeringItems.PENTACLE_SCHEMATIC.isIn(stack);
            }
        };
        this.outputSchematic = new SlotItemHandler(this, (IItemHandler)((PucalithBlockEntity)((Object)this.contentHolder)).inventory, slot++, 149, 60){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        };
        this.inputClipboard = new SlotItemHandler(this, (IItemHandler)((PucalithBlockEntity)((Object)this.contentHolder)).inventory, slot++, 113, 21){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return AllBlocks.CLIPBOARD.isIn(stack) || stack.is(Items.BOOK) || stack.is(Items.WRITTEN_BOOK) || stack.is(Items.WRITABLE_BOOK);
            }
        };
        this.outputClipboard = new SlotItemHandler(this, (IItemHandler)((PucalithBlockEntity)((Object)this.contentHolder)).inventory, slot, 153, 21){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }
        };
        this.addSlot(this.inputSchematic);
        this.addSlot(this.outputSchematic);
        this.addSlot(this.inputClipboard);
        this.addSlot(this.outputClipboard);
        int inventoryY = OccultEngineeringGuiTextures.PUCALITH.getHeight() + 4 + 18;
        this.addPlayerSlots(27, inventoryY);
    }

    protected void saveData(PucalithBlockEntity pucalithBlockEntity) {
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        if (index < 4) {
            this.moveItemStackTo(stack, 4, this.slots.size(), false);
        } else {
            this.moveItemStackTo(stack, 0, 1, false);
            this.moveItemStackTo(stack, 2, 3, false);
        }
        return ItemStack.EMPTY;
    }
}

