/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.entity.puca.brain;

import io.github.irishgreencitrus.occultengineering.content.entity.puca.HopToWalkTarget;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.PucaEntity;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.brain.NearbyAnyBlocksSensor;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.brain.PlaceBlock;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.brain.PucaBrain;
import io.github.irishgreencitrus.occultengineering.content.entity.puca.brain.SetWalkTargetAndWaitUntilReached;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PucaConstructionBrain
extends PucaBrain {
    public PucaConstructionBrain(PucaEntity entity) {
        super(entity);
    }

    @Override
    public void tick() {
    }

    @Override
    protected void onInit() {
    }

    @Override
    public List<ExtendedSensor<PucaEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyAnyBlocksSensor()});
    }

    @Override
    public BrainActivityGroup<PucaEntity> getCoreTasks() {
        if (((PucaEntity)this.entity).nextTargetPos == null || ((PucaEntity)this.entity).nextBlockState == null || ((PucaEntity)this.entity).returnHomePosition == null) {
            return BrainActivityGroup.empty();
        }
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new HopToWalkTarget().runFor(e -> 400).cooldownFor(e -> 0), new PlaceBlock().shouldPlaceIf((e, p, s) -> e.nextTargetPos != null && e.nextTargetPos.equals(p)).stateToPlace((e, p, f) -> e.nextBlockState).whenStopping(e -> {
            e.nextBlockState = null;
        }).cooldownFor(e -> 100)});
    }

    @Override
    public BrainActivityGroup<PucaEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new SequentialBehaviour(new ExtendedBehaviour[]{new SetWalkTargetAndWaitUntilReached<PucaEntity>().target(mob -> mob.nextTargetPos).setTimeout(e -> 600).closeEnoughWhen((a, b) -> 1).cooldownFor(e -> 40), new SetWalkTargetAndWaitUntilReached<PucaEntity>().target(mob -> mob.returnHomePosition).setTimeout(e -> 600).closeEnoughWhen((a, b) -> 4).cooldownFor(e -> 40)})});
    }

    @Override
    public void onBrainSetup(Brain<? extends PucaEntity> brain) {
        super.onBrainSetup(brain);
        if (((PucaEntity)this.entity).returnHomePosition == null) {
            return;
        }
        BrainUtils.setMemory(brain, (MemoryModuleType)MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)((PucaEntity)this.entity).level().dimension(), (BlockPos)((PucaEntity)this.entity).returnHomePosition));
    }

    @Override
    public void onCleanup() {
    }
}

