/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui;

import com.klikli_dev.occultism.common.blockentity.DimensionalMineshaftBlockEntity;
import com.klikli_dev.occultism.common.container.DimensionalMineshaftContainer;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DimensionalMineshaftScreen
extends AbstractContainerScreen<DimensionalMineshaftContainer> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/otherworld_miner.png");
    public DimensionalMineshaftBlockEntity otherworldMiner;

    public DimensionalMineshaftScreen(DimensionalMineshaftContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.otherworldMiner = screenContainer.otherworldMiner;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int miningTime = this.otherworldMiner.miningTime;
        int progress = (int)(18.0f * (1.0f - (float)miningTime / (float)this.otherworldMiner.maxMiningTime));
        if (progress > 0 && miningTime > 0) {
            guiGraphics.blit(TEXTURE, this.leftPos + 61, this.topPos + 41, 176, 0, progress + 1, 4);
        }
    }
}

