/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.blockentity;

import com.klikli_dev.occultism.common.block.SpiritAttunedCrystalBlock;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.util.EntityUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GoldenSacrificialBowlRenderer
implements BlockEntityRenderer<SacrificialBowlBlockEntity> {
    public GoldenSacrificialBowlRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static float getScale(ItemStack stack) {
        BlockItem itemBlock;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (itemBlock = (BlockItem)item).getBlock() instanceof SpiritAttunedCrystalBlock) {
            return 3.0f;
        }
        return 1.0f;
    }

    public void render(SacrificialBowlBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        double yOffset;
        double xOffset;
        ItemStackHandler handler = blockEntity.itemStackHandler;
        ItemStack stack = handler.getStackInSlot(0);
        long time = blockEntity.getLevel().getGameTime();
        Direction facing = blockEntity.getBlockState().hasProperty((Property)BlockStateProperties.FACING) ? (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING) : Direction.UP;
        poseStack.pushPose();
        poseStack.pushPose();
        double offset = Math.sin(((float)(time - blockEntity.lastChangeTime) + partialTicks) / 16.0f) * 0.5 + 0.5;
        double fixedOffset = 0.2;
        double d = facing.getAxis() == Direction.Axis.X ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -(offset /= 4.0) - fixedOffset) : (xOffset = 0.0);
        double d2 = facing.getAxis() == Direction.Axis.Y ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -offset - fixedOffset) : (yOffset = 0.0);
        double zOffset = facing.getAxis() == Direction.Axis.Z ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? offset + fixedOffset : -offset - fixedOffset) : 0.0;
        poseStack.translate(0.5 + xOffset, 0.5 + yOffset, 0.5 + zOffset);
        long systemTime = System.currentTimeMillis();
        float angle = systemTime / 16L % 360L;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        float scale = GoldenSacrificialBowlRenderer.getScale(stack) * 0.5f;
        poseStack.scale(scale, scale, scale);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Level level = blockEntity.getLevel();
        BakedModel model = itemRenderer.getModel(stack, level, null, 0);
        itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, model);
        if (!stack.isEmpty() && blockEntity instanceof GoldenSacrificialBowlBlockEntity) {
            ItemStack[] itemStackList;
            GoldenSacrificialBowlBlockEntity goldenBowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
            poseStack.translate(0.0, 3.2 - (0.5 + yOffset) / (double)scale, 0.0);
            if (!goldenBowl.itemUseFulfilled() && (itemStackList = ((RitualRecipe)goldenBowl.getCurrentRitualRecipe().value()).getItemToUse().getItems()).length > 0) {
                int index = itemStackList.length == 1 ? 0 : (int)(System.currentTimeMillis() / 2880L % (long)itemStackList.length);
                ItemStack itemStack = itemStackList[index];
                float scaleUse = GoldenSacrificialBowlRenderer.getScale(itemStack) * 0.5f;
                poseStack.scale(scaleUse, scaleUse, scaleUse);
                BakedModel modelItem = itemRenderer.getModel(itemStack, level, null, 0);
                itemRenderer.render(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, combinedLight, combinedOverlay, modelItem);
            }
            if (!goldenBowl.sacrificeFulfilled()) {
                LivingEntity pLivingEntity = (LivingEntity)EntityUtil.getEntityInTag(level, ((RitualRecipe)goldenBowl.currentRitualRecipe.value()).getEntityToSacrifice()).create(level);
                if (pLivingEntity == null) {
                    return;
                }
                float maxSize = (float)Math.max(pLivingEntity.getHitbox().getXsize(), Math.max(pLivingEntity.getHitbox().getYsize(), pLivingEntity.getHitbox().getZsize()));
                float eScale = 0.5f / maxSize;
                poseStack.scale(eScale, eScale, eScale);
                EntityUtil.renderEntity(poseStack, pLivingEntity, buffer, partialTicks);
            }
        }
        poseStack.popPose();
        poseStack.mulPose(facing.getRotation());
        poseStack.popPose();
    }
}

