/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.OtherstoneFrameBlock;
import com.klikli_dev.occultism.common.blockentity.EntityWormholeBlockEntity;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class EntityWormholeBlock
extends OtherstoneFrameBlock
implements EntityBlock,
Portal {
    public static final MapCodec<EntityWormholeBlock> CODEC = EntityWormholeBlock.simpleCodec(EntityWormholeBlock::new);
    public static final IntegerProperty EXIT_ROTATION_X = IntegerProperty.create((String)"exit_rotation_x", (int)0, (int)5);
    public static final IntegerProperty EXIT_ROTATION_Y = IntegerProperty.create((String)"exit_rotation_y", (int)0, (int)8);

    public EntityWormholeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EXIT_ROTATION_X, (Comparable)Integer.valueOf(0))).setValue((Property)EXIT_ROTATION_Y, (Comparable)Integer.valueOf(0)));
    }

    protected boolean isPathfindable(@NotNull BlockState pState, @NotNull PathComputationType pPathComputationType) {
        return false;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EXIT_ROTATION_X, EXIT_ROTATION_Y});
        super.createBlockStateDefinition(builder);
    }

    public void onRemove(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity != null) {
                StorageUtil.dropInventoryItems(blockEntity);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        if (!pLevel.isClientSide) {
            ItemStack heldItem = pPlayer.getItemInHand(pHand);
            if (pStack.is((Item)OccultismItems.SPIRIT_ATTUNED_GEM.get())) {
                if (pHand.equals((Object)InteractionHand.MAIN_HAND)) {
                    pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)EXIT_ROTATION_Y), 10);
                } else {
                    pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)EXIT_ROTATION_X), 10);
                }
                return ItemInteractionResult.CONSUME;
            }
            EntityWormholeBlockEntity wormhole = (EntityWormholeBlockEntity)pLevel.getBlockEntity(pPos);
            if (wormhole != null) {
                ItemStackHandler handler = wormhole.itemStackHandler;
                ItemStack itemStack = handler.getStackInSlot(0);
                if (pPlayer.isShiftKeyDown() && !itemStack.isEmpty()) {
                    if (heldItem.isEmpty()) {
                        pPlayer.setItemInHand(pHand, handler.extractItem(0, 64, false));
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)handler.extractItem(0, 64, false));
                    }
                    pLevel.playSound(null, pPos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    wormhole.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                if (itemStack.isEmpty() && pStack.is(ItemTags.COMPASSES)) {
                    pPlayer.setItemInHand(pHand, handler.insertItem(0, heldItem, false));
                    pLevel.playSound(null, pPos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    wormhole.setChanged();
                    return ItemInteractionResult.CONSUME;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return OccultismBlockEntities.ENTITY_WORMHOLE.get().create(blockPos, blockState);
    }

    protected void entityInside(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        BlockEntity blockEntity;
        if (!level.isClientSide && entity.canUsePortal(false) && (Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()))), (VoxelShape)state.getShape((BlockGetter)level, pos), (BooleanOp)BooleanOp.AND) || entity instanceof Projectile) && (blockEntity = level.getBlockEntity(pos)) instanceof EntityWormholeBlockEntity) {
            EntityWormholeBlockEntity wormholeBlockEntity = (EntityWormholeBlockEntity)blockEntity;
            if (!wormholeBlockEntity.itemStackHandler.getStackInSlot(0).isEmpty()) {
                entity.setAsInsidePortal((Portal)this, pos);
            }
        }
    }

    public DimensionTransition getPortalDestination(ServerLevel level, @NotNull Entity entity, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EntityWormholeBlockEntity) {
            ServerLevel serverlevel;
            ServerPlayer serverPlayer;
            EntityWormholeBlockEntity wormhole = (EntityWormholeBlockEntity)blockEntity;
            ItemStack compass = wormhole.itemStackHandler.getStackInSlot(0);
            ResourceKey resourcekey = null;
            BlockPos blockpos = null;
            if (compass.has(DataComponents.LODESTONE_TRACKER)) {
                Optional globalPos;
                LodestoneTracker test = (LodestoneTracker)compass.get(DataComponents.LODESTONE_TRACKER);
                if (test != null && (globalPos = test.target()).isPresent()) {
                    resourcekey = ((GlobalPos)globalPos.get()).dimension();
                    blockpos = ((GlobalPos)globalPos.get()).pos().above();
                }
            } else if (compass.is(Items.COMPASS)) {
                Component name;
                resourcekey = level.dimension();
                if (compass.has(DataComponents.CUSTOM_NAME) && (name = (Component)compass.get(DataComponents.CUSTOM_NAME)) != null) {
                    if (name.getString().equals("RTP")) {
                        resourcekey = entity.level().dimension();
                        blockpos = this.findSafeRTP((Level)level, entity, Occultism.SERVER_CONFIG.itemSettings.maxTryRTP.getAsInt());
                    }
                    if (name.getString().equals("HOME") && entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        ResourceKey tempKey = player.getRespawnDimension();
                        ServerLevel tempLevel = level.getServer().getLevel(tempKey);
                        BlockPos tempPos = player.getRespawnPosition();
                        if (tempLevel != null && tempPos != null) {
                            Optional optional;
                            BlockState blockstate = tempLevel.getBlockState(tempPos);
                            Block block = blockstate.getBlock();
                            if (block instanceof RespawnAnchorBlock && (Integer)blockstate.getValue((Property)RespawnAnchorBlock.CHARGE) > 0 && RespawnAnchorBlock.canSetSpawn((Level)tempLevel)) {
                                Optional optional2 = RespawnAnchorBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)tempLevel, (BlockPos)tempPos);
                                if (optional2.isPresent()) {
                                    blockpos = new BlockPos((int)((Vec3)optional2.get()).x(), (int)((Vec3)optional2.get()).y(), (int)((Vec3)optional2.get()).z());
                                    resourcekey = tempKey;
                                }
                            } else if (block instanceof BedBlock && BedBlock.canSetSpawn((Level)tempLevel) && (optional = BedBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)tempLevel, (BlockPos)tempPos, (Direction)((Direction)blockstate.getValue((Property)BedBlock.FACING)), (float)player.getRespawnAngle())).isPresent()) {
                                blockpos = new BlockPos((int)((Vec3)optional.get()).x(), (int)((Vec3)optional.get()).y(), (int)((Vec3)optional.get()).z());
                                resourcekey = tempKey;
                            }
                        }
                    }
                }
            } else if (compass.is(Items.RECOVERY_COMPASS) && entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).getLastDeathLocation().isPresent()) {
                resourcekey = ((GlobalPos)serverPlayer.getLastDeathLocation().get()).dimension();
                blockpos = ((GlobalPos)serverPlayer.getLastDeathLocation().get()).pos();
            } else if (compass.has(OccultismDataComponents.SPIRIT_ENTITY_UUID)) {
                UUID spirit = ItemNBTUtil.getSpiritEntityUUID(compass);
                if (spirit != null) {
                    for (ServerLevel allLvl : level.getServer().getAllLevels()) {
                        Entity targetEntity = allLvl.getEntity(spirit);
                        if (targetEntity == null) continue;
                        resourcekey = targetEntity.level().dimension();
                        blockpos = targetEntity.blockPosition();
                        break;
                    }
                } else {
                    return null;
                }
            }
            ServerLevel serverLevel = serverlevel = resourcekey == null ? null : level.getServer().getLevel(resourcekey);
            if (serverlevel == null) {
                return null;
            }
            if (blockpos == null) {
                blockpos = serverlevel.getSharedSpawnPos();
            }
            if (serverlevel.getBlockState(blockpos).isSuffocating((BlockGetter)serverlevel, blockpos)) {
                return null;
            }
            BlockState state = level.getBlockState(pos);
            return new DimensionTransition(serverlevel, blockpos.getBottomCenter(), entity.getDeltaMovement(), (Integer)state.getValue((Property)EXIT_ROTATION_Y) == 0 ? entity.getYHeadRot() : this.getExitRotY(state), (Integer)state.getValue((Property)EXIT_ROTATION_X) == 0 ? entity.getXRot() : this.getExitRotX(state), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
        }
        return null;
    }

    public float getExitRotY(BlockState state) {
        return switch ((Integer)state.getValue((Property)EXIT_ROTATION_Y)) {
            case 2 -> 45.0f;
            case 3 -> 90.0f;
            case 4 -> 135.0f;
            case 5 -> 180.0f;
            case 6 -> 225.0f;
            case 7 -> 270.0f;
            case 8 -> 315.0f;
            default -> 0.0f;
        };
    }

    public float getExitRotX(BlockState state) {
        return switch ((Integer)state.getValue((Property)EXIT_ROTATION_X)) {
            case 2 -> 45.0f;
            case 3 -> 90.0f;
            case 4 -> -45.0f;
            case 5 -> -90.0f;
            default -> 0.0f;
        };
    }

    private BlockPos findSafeRTP(Level level, Entity entity, int recursionLeft) {
        if (recursionLeft <= 0) {
            return null;
        }
        int range = Math.min((int)level.getWorldBorder().getDistanceToBorder(entity), Occultism.SERVER_CONFIG.itemSettings.maxDistanceRTP.getAsInt());
        BlockPos blockpos = entity.blockPosition().offset(RandomSource.create().nextInt(-range, range), level.getMaxBuildHeight(), RandomSource.create().nextInt(-range, range));
        while (level.getBlockState(blockpos.below()).is(BlockTags.AIR) && blockpos.getY() > level.getMinBuildHeight()) {
            blockpos = blockpos.below();
        }
        if (blockpos.getY() > 10 && level.getBlockState(blockpos.below()).is(Blocks.BEDROCK)) {
            blockpos = blockpos.below(5);
            while (!level.getBlockState(blockpos.below()).is(BlockTags.AIR) && blockpos.getY() > level.getMinBuildHeight()) {
                blockpos = blockpos.below();
            }
            while (level.getBlockState(blockpos.below()).is(BlockTags.AIR) && blockpos.getY() > level.getMinBuildHeight()) {
                blockpos = blockpos.below();
            }
        }
        return blockpos.getY() == level.getMinBuildHeight() || level.getBlockState(blockpos.below()).is(Blocks.WATER) || level.getBlockState(blockpos.below()).is(Blocks.LAVA) ? this.findSafeRTP(level, entity, recursionLeft - 1) : blockpos;
    }

    public void pullEntity(ServerLevel level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EntityWormholeBlockEntity) {
            UUID spirit;
            EntityWormholeBlockEntity wormhole = (EntityWormholeBlockEntity)blockEntity;
            if (wormhole.itemStackHandler.getStackInSlot(0).has(OccultismDataComponents.SPIRIT_ENTITY_UUID) && (spirit = ItemNBTUtil.getSpiritEntityUUID(wormhole.itemStackHandler.getStackInSlot(0))) != null) {
                for (ServerLevel allLvl : Objects.requireNonNull(level.getServer()).getAllLevels()) {
                    Entity targetEntity = allLvl.getEntity(spirit);
                    if (targetEntity == null || !targetEntity.canUsePortal(false)) continue;
                    DimensionTransition transition = new DimensionTransition(level, pos.getBottomCenter(), targetEntity.getDeltaMovement(), (Integer)state.getValue((Property)EXIT_ROTATION_Y) == 0 ? targetEntity.getYHeadRot() : this.getExitRotY(state), (Integer)state.getValue((Property)EXIT_ROTATION_X) == 0 ? targetEntity.getXRot() : this.getExitRotX(state), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
                    targetEntity.changeDimension(transition);
                    return;
                }
            }
        }
    }
}

