/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.storage;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StableWormholeBlockItem
extends BlockItem {
    public StableWormholeBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void verifyComponentsAfterLoad(ItemStack pStack) {
        super.verifyComponentsAfterLoad(pStack);
        if (pStack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            pStack.set(DataComponents.RARITY, (Object)Rarity.UNCOMMON);
        } else {
            pStack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!level.isClientSide && player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof IStorageController) {
            if (stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
                CustomData.update((DataComponentType)DataComponents.BLOCK_ENTITY_DATA, (ItemStack)stack, data -> data.put("linkedStorageControllerPosition", (Tag)GlobalBlockPos.from(blockEntity).serializeNBT((HolderLookup.Provider)level.registryAccess())));
            }
            stack.set(OccultismDataComponents.LINKED_STORAGE_CONTROLLER, (Object)GlobalBlockPos.from(blockEntity));
            stack.set(DataComponents.RARITY, (Object)Rarity.RARE);
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.set_storage_controller")), true);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            GlobalBlockPos globalPos = (GlobalBlockPos)pStack.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
            String formattedPosition = ChatFormatting.GOLD.toString() + String.valueOf(ChatFormatting.BOLD) + globalPos.toString() + String.valueOf(ChatFormatting.RESET);
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.linked"), (Object[])new Object[]{formattedPosition}));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.unlinked")));
        }
    }
}

