/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class OccultismStartupConfig {
    public final DimensionalMineshaftSettings dimensionalMineshaft;
    public final RitualSettings rituals;
    public final ModConfigSpec spec;

    public OccultismStartupConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.dimensionalMineshaft = new DimensionalMineshaftSettings(builder);
        this.rituals = new RitualSettings(builder);
        this.spec = builder.build();
    }

    public static class DimensionalMineshaftSettings {
        public final MinerSpiritSettings minerFoliotUnspecialized;
        public final MinerSpiritSettings minerDjinniOres;
        public final MinerSpiritSettings minerAfritDeeps;
        public final MinerSpiritSettings minerMaridMaster;
        public final MinerSpiritSettings minerAncientEldritch;

        public DimensionalMineshaftSettings(ModConfigSpec.Builder builder) {
            builder.comment("Dimensional Mineshaft Settings").push("dimensional_mineshaft");
            this.minerFoliotUnspecialized = new MinerSpiritSettings("miner_foliot_unspecialized", builder, 400, 1, 1000);
            this.minerDjinniOres = new MinerSpiritSettings("miner_djinni_ores", builder, 300, 1, 400);
            this.minerAfritDeeps = new MinerSpiritSettings("miner_afrit_deeps", builder, 200, 1, 800);
            this.minerMaridMaster = new MinerSpiritSettings("miner_marid_master", builder, 100, 1, 1600);
            this.minerAncientEldritch = new MinerSpiritSettings("miner_ancient_eldritch", builder, 15, 1, 3200);
            builder.pop();
        }

        public static class MinerSpiritSettings {
            public final ModConfigSpec.IntValue maxMiningTime;
            public final ModConfigSpec.IntValue rollsPerOperation;
            public final ModConfigSpec.IntValue durability;

            public MinerSpiritSettings(String oreName, ModConfigSpec.Builder builder, int maxMiningTime, int rollsPerOperation, int durability) {
                builder.comment("Miner Spirit Settings").push(oreName);
                this.maxMiningTime = builder.comment("The amount of time it takes the spirit to perform one mining operation.").defineInRange("maxMiningTime", maxMiningTime, 0, Integer.MAX_VALUE);
                this.rollsPerOperation = builder.comment("The amount of blocks the spirit will obtain per mining operation").defineInRange("rollsPerOperation", rollsPerOperation, 0, Integer.MAX_VALUE);
                this.durability = builder.comment("The amount of mining operations the spirit can perform before breaking.").defineInRange("durability", durability, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class RitualSettings {
        public final ModConfigSpec.ConfigValue<List<? extends String>> possibleSpiritNames;
        public final ModConfigSpec.DoubleValue usePossibleSpiritNamesChance;

        public RitualSettings(ModConfigSpec.Builder builder) {
            builder.comment("Ritual Settings").push("rituals");
            this.possibleSpiritNames = builder.comment("By default spirit names are generated randomly. This list can be used as an additional source of spirit names, or even a full replacement, depending on the configuration of \"usePossibleSpiritNamesChance\".").defineList("possibleSpiritNames", new ArrayList(), () -> "A Name", e -> e instanceof String);
            this.usePossibleSpiritNamesChance = builder.comment(new String[]{"0.0 (default) to only use random names.", "1.0 to only use the names in \"possibleSpiritNames\"", "0.1-0.9 to use a mix of both, the higher the value the higher the chance of using a name from this list instead of a random name.", "Will be ignored if \"possibleSpiritNames\" is empty."}).defineInRange("usePossibleSpiritNamesChance", 0.0, 0.0, 1.0);
            builder.pop();
        }
    }
}

