/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.occultism.datagen.ItemModelsGenerator;
import com.klikli_dev.occultism.datagen.OccultismAdvancementSubProvider;
import com.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.klikli_dev.occultism.datagen.PentacleProvider;
import com.klikli_dev.occultism.datagen.StandardBlockStateProvider;
import com.klikli_dev.occultism.datagen.lang.ENUSProvider;
import com.klikli_dev.occultism.datagen.loot.OccultismBlockLoot;
import com.klikli_dev.occultism.datagen.loot.OccultismEntityLoot;
import com.klikli_dev.occultism.datagen.loot.OccultismLootModifiers;
import com.klikli_dev.occultism.datagen.loot.OccultismLootTableProvider;
import com.klikli_dev.occultism.datagen.recipe.OccultismRecipeProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismBiomeTagProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismBlockTagProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismEntityTypeTagProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismItemTagProvider;
import com.klikli_dev.occultism.datagen.worldgen.OccultismRegistries;
import java.util.List;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismLootTableProvider(generator.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(OccultismBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(OccultismEntityLoot::new, LootContextParamSets.ENTITY)), event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new PentacleProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper(), List.of(new OccultismAdvancementSubProvider())));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismRecipeProvider(generator.getPackOutput(), event.getLookupProvider()));
        OccultismBlockTagProvider forgeBlockProvider = new OccultismBlockTagProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)forgeBlockProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismEntityTypeTagProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismItemTagProvider(generator.getPackOutput(), event.getLookupProvider(), forgeBlockProvider.contentsGetter(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismBiomeTagProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelsGenerator(generator.getPackOutput(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new StandardBlockStateProvider(generator.getPackOutput(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new OccultismLootModifiers(generator.getPackOutput(), event.getLookupProvider()));
        ENUSProvider enUSProvider = new ENUSProvider(generator.getPackOutput());
        generator.addProvider(event.includeServer(), (DataProvider)new BookProvider(generator.getPackOutput(), event.getLookupProvider(), "occultism", List.of(new OccultismBookProvider((ModonomiconLanguageProvider)enUSProvider))));
        generator.addProvider(event.includeClient(), (DataProvider)enUSProvider);
        event.getGenerator().addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), OccultismRegistries.BUILDER, Set.of("occultism")));
    }
}

