/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.google.common.base.Preconditions;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.integration.emi.impl.EmiHelper;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.util.StorageUtil;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageSetRecipeByTemplate
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_recipe_by_template");
    public static final CustomPacketPayload.Type<MessageSetRecipeByTemplate> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetRecipeByTemplate> STREAM_CODEC = CustomPacketPayload.codec(MessageSetRecipeByTemplate::encode, MessageSetRecipeByTemplate::new);
    @Nullable
    private ResourceLocation recipeId;
    private NonNullList<ItemStack> ingredientTemplates;
    private int recipeAmount;

    public MessageSetRecipeByTemplate(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetRecipeByTemplate(@Nullable ResourceLocation recipeId, NonNullList<ItemStack> ingredientTemplates, int recipeAmount) {
        this.recipeId = recipeId;
        this.ingredientTemplates = ingredientTemplates;
        this.recipeAmount = recipeAmount;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingContainer craftMatrix = container.getCraftMatrix();
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        for (int i = 0; i < this.recipeAmount; ++i) {
            for (int slot = 0; slot < 9; ++slot) {
                Ingredient ingredient = (Ingredient)ingredients.get(slot);
                if (ingredient.isEmpty()) continue;
                ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (Predicate<ItemStack>)ingredient, 1, true);
                if (!extractedStack.isEmpty()) {
                    StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (Predicate<ItemStack>)ingredient, 1, false);
                    if (ItemStack.isSameItemSameComponents((ItemStack)craftMatrix.getItem(slot), (ItemStack)extractedStack)) {
                        craftMatrix.getItem(slot).setCount(craftMatrix.getItem(slot).getCount() + 1);
                        continue;
                    }
                    craftMatrix.setItem(slot, extractedStack);
                    continue;
                }
                ItemStack stack = storageController.getItemStack((Predicate<ItemStack>)ingredient, 1, false);
                if (stack.isEmpty()) continue;
                if (ItemStack.isSameItemSameComponents((ItemStack)craftMatrix.getItem(slot), (ItemStack)stack)) {
                    craftMatrix.getItem(slot).setCount(craftMatrix.getItem(slot).getCount() + 1);
                    continue;
                }
                craftMatrix.setItem(slot, stack);
            }
        }
        container.updateCraftingSlots(true);
        Networking.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeNullable((Object)this.recipeId, FriendlyByteBuf::writeResourceLocation);
        ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode((Object)buf, this.ingredientTemplates);
        buf.writeInt(this.recipeAmount);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.recipeId = (ResourceLocation)buf.readNullable(FriendlyByteBuf::readResourceLocation);
        this.ingredientTemplates = NonNullList.copyOf((Collection)((Collection)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode((Object)buf)));
        this.recipeAmount = buf.readInt();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private NonNullList<Ingredient> getDesiredIngredients(Player player) {
        RecipeHolder recipe;
        if (this.recipeId != null && (recipe = (RecipeHolder)player.level().getRecipeManager().byKey(this.recipeId).orElse(null)) != null) {
            return EmiHelper.ensure3by3CraftingMatrix(recipe.value());
        }
        NonNullList ingredients = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got %d ingredient templates from client, expected %d", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack template = (ItemStack)this.ingredientTemplates.get(i);
            if (template.isEmpty()) continue;
            ingredients.set(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{template}));
        }
        return ingredients;
    }
}

