/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.client.screen;

import com.lumengrid.oritechthings.client.screen.component.ToggleButton;
import com.lumengrid.oritechthings.menu.AcceleratorSpeedSensorMenu;
import com.lumengrid.oritechthings.network.packet.UpdateSpeedSensorC2SPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class AcceleratorSpeedSensorScreen
extends AbstractContainerScreen<AcceleratorSpeedSensorMenu> {
    private final Component title = Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.title");
    public static ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"oritechthings", (String)"textures/gui/speed_sensor.png");

    public AcceleratorSpeedSensorScreen(AcceleratorSpeedSensorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
        gui.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xFFFFFF);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.leftPos + 45, this.topPos + 46, 17, 17, (Component)Component.literal((String)(((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater() ? ">" : "<")), button -> {
            boolean newState = !((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater();
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), ((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit(), ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), newState, ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)Component.literal((String)(newState ? ">" : "<")));
        }, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), -16777216, -16777216));
        EditBox speedInput = new EditBox(this.font, this.leftPos + 65, this.topPos + 45, 55, 20, (Component)Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.speed_input"));
        speedInput.setMaxLength(6);
        speedInput.setFilter(s -> s.matches("\\d*") && !s.isEmpty());
        speedInput.setValue(String.valueOf(((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit()));
        speedInput.setResponder(this::onSpeedEntered);
        this.addRenderableWidget((GuiEventListener)speedInput);
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.leftPos + 130, this.topPos + 45, 30, 18, (Component)(((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled() ? Component.translatable((String)"tooltip.oritechthings.state.on") : Component.translatable((String)"tooltip.oritechthings.state.off")), button -> {
            boolean newState = !((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled();
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), ((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit(), newState, ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)(((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled() ? Component.translatable((String)"tooltip.oritechthings.state.on") : Component.translatable((String)"tooltip.oritechthings.state.off")));
        }, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), -7093123, -2070938));
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.leftPos + 8, this.topPos + 45, 32, 18, (Component)(((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode() ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.auto") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.manual")), button -> {
            boolean newState = !((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode();
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), ((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit(), ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), newState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)(newState ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.auto") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.manual")));
        }, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), -11893016, -11893016));
    }

    private void onSpeedEntered(String input) {
        try {
            int value = Integer.parseInt(input);
            value = Math.max(0, Math.min(value, 999999));
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), value, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (NumberFormatException e) {
            System.out.println(e.getMessage());
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND, x, y, 0.0f, 0.0f, 176, 166, 256, 256);
        this.renderParticleAcceleratorMessage(guiGraphics);
    }

    private void renderParticleAcceleratorMessage(GuiGraphics guiGraphics) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.controller"), this.leftPos + 10, this.topPos + 20, 0xFFFFFF);
        if (((AcceleratorSpeedSensorMenu)this.menu).be.getTargetDesignator() == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.controller_not_set").withStyle(style -> style.withColor(0xFF5555).withBold(Boolean.valueOf(true))), this.leftPos + 100, this.topPos + 32, 0xFF5555);
        } else {
            BlockPos target = ((AcceleratorSpeedSensorMenu)this.menu).be.getTargetDesignator();
            guiGraphics.drawString(this.font, (Component)Component.literal((String)target.toShortString()).withStyle(style -> style.withColor(255)), this.leftPos + 40, this.topPos + 32, 255);
        }
    }
}

