/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.offline;

import io.wispforest.owo.Owo;
import io.wispforest.owo.offline.DataSavedEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public final class OfflineDataLookup {
    private OfflineDataLookup() {
    }

    public static void put(UUID player, CompoundTag nbt) {
        ((DataSavedEvents.PlayerData)DataSavedEvents.PLAYER_DATA.invoker()).onSaved(player, nbt);
        try {
            Path savedPlayersPath = Owo.currentServer().getWorldPath(LevelResource.PLAYER_DATA_DIR);
            Path file = Files.createTempFile(savedPlayersPath, player.toString() + "-", ".dat", new FileAttribute[0]);
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)file);
            Path newDataFile = savedPlayersPath.resolve(String.valueOf(player) + ".dat");
            Path oldDataFile = savedPlayersPath.resolve(String.valueOf(player) + ".dat_old");
            Util.safeReplaceFile((Path)newDataFile, (Path)file, (Path)oldDataFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static CompoundTag get(UUID player) {
        try {
            Path savedPlayersPath = Owo.currentServer().getWorldPath(LevelResource.PLAYER_DATA_DIR);
            Path savedDataPath = savedPlayersPath.resolve(player.toString() + ".dat");
            CompoundTag rawNbt = NbtIo.readCompressed((Path)savedDataPath, (NbtAccounter)NbtAccounter.unlimitedHeap());
            int dataVersion = rawNbt.contains("DataVersion", 3) ? rawNbt.getInt("DataVersion") : -1;
            return DataFixTypes.PLAYER.updateToCurrentVersion(DataFixers.getDataFixer(), rawNbt, dataVersion);
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't get player data for offline player {}", (Object)player, (Object)e);
            return null;
        }
    }

    public static void edit(UUID player, Function<CompoundTag, CompoundTag> editor) {
        OfflineDataLookup.put(player, editor.apply(OfflineDataLookup.get(player)));
    }

    public static List<UUID> savedPlayers() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        Path savedPlayersPath = Owo.currentServer().getWorldPath(LevelResource.PLAYER_DATA_DIR);
        if (!Files.isDirectory(savedPlayersPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            Iterator iterator = Files.list(savedPlayersPath).iterator();
            while (iterator.hasNext()) {
                Path savedPlayerFile = (Path)iterator.next();
                if (Files.isDirectory(savedPlayerFile, new LinkOption[0]) || !savedPlayerFile.toString().endsWith(".dat")) continue;
                try {
                    String filename = savedPlayerFile.getFileName().toString();
                    String uuidStr = filename.substring(0, filename.lastIndexOf(46));
                    UUID uuid = UUID.fromString(uuidStr);
                    list.add(uuid);
                }
                catch (IllegalArgumentException iae) {
                    Owo.LOGGER.error("Encountered invalid UUID in playerdata directory", (Throwable)iae);
                }
            }
        }
        catch (IOException e) {
            Owo.LOGGER.error("Couldn't list offline player UUIDs", (Throwable)e);
            throw new RuntimeException(e);
        }
        return list;
    }
}

