/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

public interface Easing {
    public static final Easing LINEAR = x -> x;
    public static final Easing SINE = x -> (float)(Math.sin((double)x * Math.PI - 1.5707963267948966) * 0.5 + 0.5);
    public static final Easing QUADRATIC = x -> (double)x < 0.5 ? 2.0f * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
    public static final Easing CUBIC = x -> (double)x < 0.5 ? 4.0f * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
    public static final Easing QUARTIC = x -> (double)x < 0.5 ? 8.0f * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
    public static final Easing EXPO = x -> {
        if (x == 0.0f) {
            return 0.0f;
        }
        if (x == 1.0f) {
            return 1.0f;
        }
        return (double)x < 0.5 ? (float)Math.pow(2.0, 20.0f * x - 10.0f) / 2.0f : (2.0f - (float)Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0f;
    };

    public float apply(float var1);
}

