/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.manmaed.petrock.block.PRBlocks;
import net.manmaed.petrock.item.PRItems;
import net.manmaed.petrock.libs.RLHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vazkii.patchouli.api.PatchouliAPI;

public class PRRecipeProvider
extends RecipeProvider {
    private static final RecipeCategory misc = RecipeCategory.MISC;
    private static final RecipeCategory block = RecipeCategory.BUILDING_BLOCKS;
    private static final RecipeCategory food = RecipeCategory.FOOD;

    public PRRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, completableFuture);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)food, (ItemLike)((ItemLike)PRItems.KIBBLE.get())).define(Character.valueOf('m'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE.asItem()})).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PRItems.STONEIUM.get()})).define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKIE})).pattern("msm").pattern("scs").pattern("msm").unlockedBy("has_cookie", PRRecipeProvider.has((ItemLike)Items.COOKIE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)misc, (ItemLike)((ItemLike)PRItems.ORDER_FORM.get())).define(Character.valueOf('p'), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER})).define(Character.valueOf('i'), Ingredient.of((ItemLike[])new ItemLike[]{Items.INK_SAC})).pattern("ppp").pattern("pip").pattern("ppp").unlockedBy("has_ink", PRRecipeProvider.has((ItemLike)Items.INK_SAC)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)misc, (ItemLike)((ItemLike)PRItems.STONE_LEGS.get())).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE.asItem()})).pattern("s s").pattern("s s").unlockedBy("has_stone", PRRecipeProvider.has((ItemLike)Blocks.STONE.asItem())).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)misc, (ItemLike)((ItemLike)PRItems.PETROCKWITHLEGSBOX.get())).requires((ItemLike)PRItems.PETROCKBOX.get()).requires(PRItems.STONE_LEGS).unlockedBy("has_stone_legs", PRRecipeProvider.has((ItemLike)((ItemLike)PRItems.STONE_LEGS.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)misc, (ItemLike)((ItemLike)PRItems.STONEIUM.get()), (int)9).requires((ItemLike)PRBlocks.STONEIUM_BLOCK.get()).unlockedBy("has_stoneium_ingot", PRRecipeProvider.has((ItemLike)((ItemLike)PRItems.STONEIUM.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)block, (ItemLike)((ItemLike)PRBlocks.STONEIUM_BLOCK.get())).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PRItems.STONEIUM.get()})).pattern("sss").pattern("sss").pattern("sss").unlockedBy("has_stoneium_ingot", PRRecipeProvider.has((ItemLike)((ItemLike)PRItems.STONEIUM.get()))).save(recipeOutput);
        PRRecipeProvider.oreToIngot((Block)PRBlocks.STONEIUM_ORE.get(), (Item)PRItems.STONEIUM.get(), recipeOutput);
        PRRecipeProvider.oreToIngot((Block)PRBlocks.DEEPSLATE_STONEIUM_ORE.get(), (Item)PRItems.STONEIUM.get(), recipeOutput);
        PRRecipeProvider.ingotToIngot((Item)PRItems.RAW_STONEIUM.get(), (Item)PRItems.STONEIUM.get(), recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)misc, (ItemStack)PatchouliAPI.get().getBookStack(RLHelper.location("petrock_care_guide"))).requires((ItemLike)Items.BOOK).requires(PRItems.STONEIUM).unlockedBy("has_stoneium_ingot", PRRecipeProvider.has(PRItems.STONEIUM)).save(recipeOutput, "patchouli:petrock_care_guide");
    }

    private static void ingotToIngot(Item rawore, Item ingot, RecipeOutput recipeOutput) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawore}), (RecipeCategory)misc, (ItemLike)ingot, (float)0.7f, (int)100).unlockedBy(PRRecipeProvider.getHasName((ItemLike)rawore), PRRecipeProvider.has((ItemLike)rawore)).save(recipeOutput, RLHelper.location(PRRecipeProvider.retunName(ingot) + "_from_blasting_" + PRRecipeProvider.retunName(rawore)));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawore}), (RecipeCategory)misc, (ItemLike)ingot, (float)0.7f, (int)200).unlockedBy(PRRecipeProvider.getHasName((ItemLike)rawore), PRRecipeProvider.has((ItemLike)rawore)).save(recipeOutput, RLHelper.location(PRRecipeProvider.retunName(ingot) + "_from_smelting_" + PRRecipeProvider.retunName(rawore)));
    }

    private static void oreToIngot(Block ore, Item ingot, RecipeOutput recipeOutput) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ore}), (RecipeCategory)misc, (ItemLike)ingot, (float)0.7f, (int)100).unlockedBy(PRRecipeProvider.getHasName((ItemLike)ore), PRRecipeProvider.has((ItemLike)ore)).save(recipeOutput, RLHelper.location(PRRecipeProvider.retunName(ingot) + "_from_blasting_" + PRRecipeProvider.retunName(ore.asItem())));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ore}), (RecipeCategory)misc, (ItemLike)ingot, (float)0.7f, (int)200).unlockedBy(PRRecipeProvider.getHasName((ItemLike)ore), PRRecipeProvider.has((ItemLike)ore)).save(recipeOutput, RLHelper.location(PRRecipeProvider.retunName(ingot) + "_from_smelting_" + PRRecipeProvider.retunName(ore.asItem())));
    }

    private static String retunName(Item item) {
        String item_with_idet = item.toString();
        String regex = "(?<=:)[^:]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(item_with_idet);
        String name = "";
        if (matcher.find()) {
            name = matcher.group();
        }
        return name;
    }
}

