/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockList
extends ArrayList<Either<TagKey<Block>, ResourceKey<Block>>> {
    public static final Codec<List<Either<TagKey<Block>, ResourceKey<Block>>>> CODEC = Codec.list(BlockListEntry.ENTRY_CODEC);

    public BlockList(@NotNull Collection<? extends Either<TagKey<Block>, ResourceKey<Block>>> c) {
        super(c);
    }

    public static BlockList of(String ... blockIds) {
        BlockList blockList = new BlockList(new ArrayList());
        for (String blockId : blockIds) {
            blockList.add(blockId);
        }
        return blockList;
    }

    public static BlockList ofDyes(String format) {
        BlockList blockList = new BlockList(new ArrayList());
        for (DyeColor dyeColor : DyeColor.values()) {
            String blockId = String.format(format, dyeColor.getName());
            blockList.add(blockId);
        }
        return blockList;
    }

    public BlockList add(TagKey<Block> block) {
        this.add(Either.left(block));
        return this;
    }

    public BlockList add(ResourceKey<Block> block) {
        this.add(Either.right(block));
        return this;
    }

    public BlockList add(Block block) {
        return this.add((ResourceKey<Block>)block.builtInRegistryHolder().key());
    }

    public BlockList addTag(ResourceLocation tag) {
        return this.add((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tag));
    }

    public BlockList add(ResourceLocation block) {
        return this.add((ResourceKey<Block>)ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)block));
    }

    public BlockList add(String blockId) {
        return this.add(ResourceLocation.parse((String)blockId));
    }

    public Set<Block> getAllBlocks(Registry<Block> registry) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (Either entry : this) {
            if (entry.left().isPresent()) {
                TagKey tag = (TagKey)entry.left().get();
                registry.getTagOrEmpty(tag).forEach((? super T blockHolder) -> blocks.add((Block)blockHolder.value()));
                continue;
            }
            if (!entry.right().isPresent()) continue;
            ResourceKey resourceKey = (ResourceKey)entry.right().get();
            registry.getOptional(resourceKey).ifPresent(blocks::add);
        }
        return blocks;
    }

    public boolean supports(BlockState state) {
        if (this.isEmpty()) {
            return false;
        }
        for (Either entry : this) {
            if (!(entry.left().isPresent() ? state.is((TagKey)entry.left().get()) : entry.right().isPresent() && state.is((ResourceKey)entry.right().get()))) continue;
            return true;
        }
        return false;
    }

    public List<Either<TagKey<Block>, ResourceKey<Block>>> asList() {
        return this;
    }

    static class BlockListEntry {
        private static final ResourceKey<Registry<Block>> registryKey = Registries.BLOCK;
        public static final Codec<Either<TagKey<Block>, ResourceKey<Block>>> ENTRY_CODEC = ExtraCodecs.TAG_OR_ELEMENT_ID.xmap(l -> l.tag() ? Either.left((Object)TagKey.create(registryKey, (ResourceLocation)l.id())) : Either.right((Object)ResourceKey.create(registryKey, (ResourceLocation)l.id())), e -> (ExtraCodecs.TagOrElementLocation)e.map(t -> new ExtraCodecs.TagOrElementLocation(t.location(), true), r -> new ExtraCodecs.TagOrElementLocation(r.location(), false)));
        Either<TagKey<Block>, ResourceKey<Block>> value;

        BlockListEntry() {
        }
    }
}

