/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ItemList
extends ArrayList<Either<TagKey<Item>, ResourceKey<Item>>> {
    public static final Codec<List<Either<TagKey<Item>, ResourceKey<Item>>>> CODEC = Codec.list(BlockListEntry.ENTRY_CODEC);

    public ItemList(@NotNull Collection<? extends Either<TagKey<Item>, ResourceKey<Item>>> c) {
        super(c);
    }

    public static ItemList of(String ... itemIds) {
        ItemList itemList = new ItemList(new ArrayList());
        for (String itemId : itemIds) {
            itemList.add(itemId);
        }
        return itemList;
    }

    public ItemList add(TagKey<Item> item) {
        this.add(Either.left(item));
        return this;
    }

    public ItemList add(ResourceKey<Item> item) {
        this.add(Either.right(item));
        return this;
    }

    public ItemList add(Item item) {
        return this.add((ResourceKey<Item>)item.builtInRegistryHolder().key());
    }

    public ItemList addTag(ResourceLocation tag) {
        return this.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag));
    }

    public ItemList add(ResourceLocation item) {
        return this.add((ResourceKey<Item>)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)item));
    }

    public ItemList add(String itemId) {
        if (itemId.startsWith("#")) {
            return this.addTag(ResourceLocation.parse((String)itemId.substring(1)));
        }
        return this.add(ResourceLocation.parse((String)itemId));
    }

    public Set<Item> getAllItems(Registry<Item> registry) {
        HashSet<Item> items = new HashSet<Item>();
        for (Either entry : this) {
            if (entry.left().isPresent()) {
                TagKey tag = (TagKey)entry.left().get();
                registry.getTagOrEmpty(tag).forEach((? super T itemHolder) -> items.add((Item)itemHolder.value()));
                continue;
            }
            if (!entry.right().isPresent()) continue;
            ResourceKey resourceKey = (ResourceKey)entry.right().get();
            registry.getOptional(resourceKey).ifPresent(items::add);
        }
        return items;
    }

    public boolean supports(Item item) {
        if (this.isEmpty()) {
            return false;
        }
        for (Either entry : this) {
            if (entry.left().isPresent()) {
                TagKey tag = (TagKey)entry.left().get();
                if (!item.builtInRegistryHolder().is(tag)) continue;
                return true;
            }
            if (!entry.right().isPresent() || !item.builtInRegistryHolder().getKey().equals(entry.right().get())) continue;
            return true;
        }
        return false;
    }

    public List<Either<TagKey<Item>, ResourceKey<Item>>> asList() {
        return this;
    }

    static class BlockListEntry {
        private static final ResourceKey<Registry<Item>> registryKey = Registries.ITEM;
        public static final Codec<Either<TagKey<Item>, ResourceKey<Item>>> ENTRY_CODEC = ExtraCodecs.TAG_OR_ELEMENT_ID.xmap(l -> l.tag() ? Either.left((Object)TagKey.create(registryKey, (ResourceLocation)l.id())) : Either.right((Object)ResourceKey.create(registryKey, (ResourceLocation)l.id())), e -> (ExtraCodecs.TagOrElementLocation)e.map(t -> new ExtraCodecs.TagOrElementLocation(t.location(), true), r -> new ExtraCodecs.TagOrElementLocation(r.location(), false)));
        Either<TagKey<Item>, ResourceKey<Item>> value;

        BlockListEntry() {
        }
    }
}

