/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data.cache;

import com.davenonymous.pipegoggles.compat.ISpecialPipeHandler;
import com.davenonymous.pipegoggles.compat.SpecialPipeHandlers;
import com.davenonymous.pipegoggles.data.EnumBoxOptimizationStrategy;
import com.davenonymous.pipegoggles.data.GoggleSupport;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import com.davenonymous.pipegoggles.items.PipeGoggleItem;
import com.davenonymous.pipegoggles.render.BoxRenderer;
import com.davenonymous.pipegoggles.render.OverlayLineRenderType;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BoxLineCache {
    public DyeColor color;
    public VertexBuffer vbo = null;
    public Set<Line> lines = new HashSet<Line>();

    public BoxLineCache(DyeColor color) {
        this.color = color;
    }

    public void clear() {
        this.lines.clear();
        if (this.vbo != null) {
            this.vbo.close();
            this.vbo = null;
        }
    }

    public void buildVBO() {
        if (this.lines.isEmpty()) {
            return;
        }
        ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(OverlayLineRenderType.forThickness((int)1).bufferSize);
        BufferBuilder bufferBuilder = new BufferBuilder(byteBufferBuilder, VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        LocalPlayer player = Minecraft.getInstance().player;
        Optional<ItemStack> optGoggleStack = PipeGoggleItem.getGoggleStack((Player)player);
        if (optGoggleStack.isEmpty()) {
            return;
        }
        PipeGoggleDataComponent goggleData = PipeGoggleItem.data(optGoggleStack.get());
        if (goggleData.isDisabled()) {
            return;
        }
        int colorInt = this.color.getTextColor() | goggleData.alpha() << 24;
        BoxRenderer.createVBO(bufferBuilder, this.lines, colorInt);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            VertexBuffer modelVertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            modelVertexBuffer.bind();
            modelVertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            this.vbo = modelVertexBuffer;
        }
    }

    public void addBlock(GoggleSupport support, BlockPos pos, Level level) {
        VoxelShape shape;
        BlockState blockState;
        ResourceLocation blockId;
        ISpecialPipeHandler handler = SpecialPipeHandlers.forMod(support.modId());
        boolean shouldContinue = handler.onShapeAdd(support, level, pos, blockId = BuiltInRegistries.BLOCK.getKey((Object)(blockState = level.getBlockState(pos)).getBlock()), blockState, shape = blockState.getShape((BlockGetter)level, pos), this.lines);
        if (!shouldContinue) {
            return;
        }
        boolean removeDuplicateLines = support.strategy() == EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES;
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            Line newLine = new Line(new Vec3(x1 + (double)pos.getX(), y1 + (double)pos.getY(), z1 + (double)pos.getZ()), new Vec3(x2 + (double)pos.getX(), y2 + (double)pos.getY(), z2 + (double)pos.getZ()));
            if (this.lines.contains(newLine)) {
                if (removeDuplicateLines) {
                    this.lines.remove(newLine);
                }
            } else {
                boolean shouldAddLine = handler.onLineAdd(support, level, pos, blockId, blockState, shape, this.lines, newLine);
                if (shouldAddLine) {
                    this.lines.add(newLine);
                }
            }
        });
    }

    public record Line(Vec3 start, Vec3 end) {
        public Line(Vec3 start, Vec3 end) {
            Vec3 origin = new Vec3(0.0, 0.0, 0.0);
            if (start.distanceTo(origin) < end.distanceTo(origin)) {
                this.start = start;
                this.end = end;
            } else {
                this.end = start;
                this.start = end;
            }
        }

        public Line shift(BlockPos offset) {
            return new Line(new Vec3(this.start().toVector3f()).subtract((double)offset.getX(), (double)offset.getY(), (double)offset.getZ()), new Vec3(this.end().toVector3f()).subtract((double)offset.getX(), (double)offset.getY(), (double)offset.getZ()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Line)) {
                return false;
            }
            Line line = (Line)o;
            return Objects.equals(this.end(), line.end()) && Objects.equals(this.start(), line.start());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.start(), this.end());
        }
    }
}

