/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data.cache;

import com.davenonymous.pipegoggles.config.Client;
import com.davenonymous.pipegoggles.data.GoggleSupport;
import com.davenonymous.pipegoggles.data.WorldTools;
import com.davenonymous.pipegoggles.data.cache.BoxLineCache;
import com.davenonymous.pipegoggles.data.cache.GoggleSupportCache;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BoxOptimizer {
    private static Map<DyeColor, BoxLineCache> BOX_LINE_CACHES = new HashMap<DyeColor, BoxLineCache>();
    private static long lastUpdateTick = Long.MIN_VALUE;

    public static BoxLineCache getBoxLineCache(DyeColor color) {
        if (BOX_LINE_CACHES.isEmpty()) {
            for (DyeColor dyeColor : DyeColor.values()) {
                BOX_LINE_CACHES.put(dyeColor, new BoxLineCache(dyeColor));
            }
        }
        return BOX_LINE_CACHES.get(color);
    }

    public static void updateBoxLineCaches(Player player, PipeGoggleDataComponent data) {
        BoxLineCache optimizer;
        boolean lastUpdateTickIsInThePast;
        Level level = player.level();
        boolean cacheIsCurrent = lastUpdateTick + (long)Client.scanRefreshRate >= level.getGameTime();
        boolean bl = lastUpdateTickIsInThePast = lastUpdateTick <= level.getGameTime();
        if (cacheIsCurrent && lastUpdateTickIsInThePast) {
            return;
        }
        BlockPos base = player.blockPosition();
        double rangeSqr = data.range() * data.range();
        int intRange = (int)data.range();
        BlockPos min = base.offset(-intRange, -intRange, -intRange);
        BlockPos max = base.offset(intRange, intRange, intRange);
        for (DyeColor color : DyeColor.values()) {
            optimizer = BoxOptimizer.getBoxLineCache(color);
            optimizer.clear();
        }
        WorldTools.foreachBlockBetween(min, max, pos -> {
            if (level.isEmptyBlock(pos)) {
                return;
            }
            if (Client.scanRadially && player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > rangeSqr) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            GoggleSupport support = GoggleSupportCache.SUPPORT_BY_BLOCK.get(state.getBlock());
            if (support == null) {
                return;
            }
            Optional<DyeColor> color = data.getColorForBlock(state.getBlock());
            if (color.isEmpty()) {
                return;
            }
            BoxLineCache cache = BoxOptimizer.getBoxLineCache(color.get());
            cache.addBlock(support, (BlockPos)pos, level);
        });
        for (DyeColor color : DyeColor.values()) {
            optimizer = BoxOptimizer.getBoxLineCache(color);
            optimizer.buildVBO();
        }
        lastUpdateTick = level.getGameTime();
    }
}

