/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.items;

import com.davenonymous.pipegoggles.config.Client;
import com.davenonymous.pipegoggles.config.Rules;
import com.davenonymous.pipegoggles.data.EnergyCosts;
import com.davenonymous.pipegoggles.data.EnumGoggleMode;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import com.davenonymous.pipegoggles.items.PipeGoggleContainer;
import com.davenonymous.pipegoggles.lib.gui.tooltip.HBoxTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.VBoxTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.WrappedStringTooltipComponent;
import com.davenonymous.pipegoggles.setup.CuriosCompat;
import com.davenonymous.pipegoggles.setup.ModDataComponents;
import com.davenonymous.pipegoggles.setup.ModItems;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class PipeGoggleItem
extends Item {
    public PipeGoggleItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public static PipeGoggleDataComponent data(ItemStack stack) {
        return (PipeGoggleDataComponent)stack.getOrDefault(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)new PipeGoggleDataComponent());
    }

    public static long getStoredEnergy(ItemStack stack) {
        PipeGoggleDataComponent goggleData = PipeGoggleItem.data(stack);
        return goggleData.storedEnergy();
    }

    public static ItemStack withEnergy(ItemStack stack, long energy) {
        PipeGoggleDataComponent goggleData = PipeGoggleItem.data(stack);
        PipeGoggleDataComponent newData = goggleData.withStoredEnergy(energy);
        ItemStack newStack = stack.copy();
        newStack.set(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)newData);
        return newStack;
    }

    public static Optional<ItemStack> getGoggleStack(Player player) {
        IItemHandler curiosInventory;
        Inventory playerInventory = player.getInventory();
        Optional<ItemStack> optGoggleStack = playerInventory.items.stream().filter(Predicate.not(ItemStack::isEmpty)).filter(stack -> stack.is((Item)ModItems.PIPE_GOGGLE_ITEM.get())).findFirst();
        if (optGoggleStack.isEmpty() && (curiosInventory = (IItemHandler)player.getCapability(CuriosCompat.CURIOS_INVENTORY)) != null && curiosInventory.getSlots() > 0) {
            for (int slot = 0; slot < curiosInventory.getSlots(); ++slot) {
                ItemStack stack2 = curiosInventory.getStackInSlot(slot);
                if (!stack2.is((Item)ModItems.PIPE_GOGGLE_ITEM.get())) continue;
                optGoggleStack = Optional.of(stack2);
                break;
            }
        }
        return optGoggleStack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide() || hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        if (player.isShiftKeyDown()) {
            ItemStack googleStack = player.getItemInHand(hand);
            PipeGoggleDataComponent goggleData = PipeGoggleItem.data(googleStack);
            PipeGoggleDataComponent newGoggleData = goggleData.withMode(goggleData.goggleMode().next());
            googleStack.set(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)newGoggleData);
            String attribute = I18n.get((String)("pipegoggles.enumgogglemode." + newGoggleData.goggleMode().getSerializedName()), (Object[])new Object[0]);
            player.displayClientMessage((Component)Component.translatable((String)"pipegoggles.message.changed_mode", (Object[])new Object[]{attribute}), true);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inventory, player1) -> new PipeGoggleContainer(id, player1.getInventory(), player1), (Component)Component.empty());
        player.openMenu((MenuProvider)provider);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean isBarVisible(ItemStack googleStack) {
        return Rules.requireEnergy && PipeGoggleItem.getStoredEnergy(googleStack) > 0L && PipeGoggleItem.getStoredEnergy(googleStack) < (long)Rules.maxEnergy;
    }

    public int getBarColor(ItemStack googleStack) {
        float storedEnergy = PipeGoggleItem.getStoredEnergy(googleStack);
        float stackMaxDamage = Rules.maxEnergy;
        float f = 1.0f - Math.max(0.0f, (stackMaxDamage - storedEnergy) / stackMaxDamage);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack googleStack) {
        return Math.round((float)PipeGoggleItem.getStoredEnergy(googleStack) * 13.0f / (float)Rules.maxEnergy);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        VBoxTooltipComponent result = new VBoxTooltipComponent(new TooltipComponent[0]);
        if (Rules.requireEnergy) {
            HBoxTooltipComponent box = new HBoxTooltipComponent(StringTooltipComponent.green(I18n.get((String)"pipegoggles.message.stored_energy", (Object[])new Object[0]) + ": "), StringTooltipComponent.gray(String.valueOf(PipeGoggleItem.getStoredEnergy(stack))));
            result.add(box);
        }
        if (Client.showHelpTooltips && Minecraft.getInstance().options.graphicsMode().get() == GraphicsStatus.FABULOUS) {
            result.add(WrappedStringTooltipComponent.red(I18n.get((String)"pipegoggles.message.fabulous_warning", (Object[])new Object[0])));
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!Rules.requireEnergy) {
            return;
        }
        PipeGoggleDataComponent data = PipeGoggleItem.data(stack);
        if (data.goggleMode() == EnumGoggleMode.OFF) {
            return;
        }
        if (!data.enoughEnergy()) {
            return;
        }
        long cost = EnergyCosts.getCost(data);
        long available = data.storedEnergy();
        if (slotId != -1) {
            ItemStack newStack = PipeGoggleItem.withEnergy(stack, available - cost);
            player.getInventory().setItem(slotId, newStack);
        } else {
            IItemHandler curiosInventory = (IItemHandler)player.getCapability(CuriosCompat.CURIOS_INVENTORY);
            if (curiosInventory != null && curiosInventory.getSlots() > 0) {
                for (int slot = 0; slot < curiosInventory.getSlots(); ++slot) {
                    ItemStack curioStack = curiosInventory.getStackInSlot(slot);
                    if (!curioStack.is((Item)ModItems.PIPE_GOGGLE_ITEM.get())) continue;
                    curioStack.set(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)data.withStoredEnergy(available - cost));
                    break;
                }
            }
        }
    }
}

