/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.widgets;

import com.davenonymous.pipegoggles.lib.gui.event.MouseClickEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetItemStack;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public class WidgetGhostSlot
extends WidgetItemStack {
    Function<ItemStack, Boolean> isValidItemStackFunc = stack -> true;

    public WidgetGhostSlot(ItemStack stack2, boolean drawSlot) {
        super(stack2, drawSlot);
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (!widget.enabled) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            ItemStack playerStack = this.getGUI().getContainer().getCarried().copy();
            playerStack.setCount(1);
            this.setValue(playerStack);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseReleasedEvent.class, (event, widget) -> WidgetEventResult.CONTINUE_PROCESSING);
    }

    public void setValueForced(ItemStack stack) {
        super.setValue(stack);
    }

    @Override
    public void setValue(ItemStack stack) {
        if (!this.isValidItemStack(stack)) {
            return;
        }
        super.setValue(stack);
    }

    public WidgetGhostSlot setIsValidItemStack(Function<ItemStack, Boolean> isValidItemStack) {
        this.isValidItemStackFunc = stack -> stack.isEmpty() || (Boolean)isValidItemStack.apply((ItemStack)stack) != false;
        return this;
    }

    public WidgetGhostSlot(ItemStack stack) {
        this(stack, true);
    }

    protected boolean isValidItemStack(ItemStack stack) {
        return this.isValidItemStackFunc == null ? true : this.isValidItemStackFunc.apply(stack);
    }
}

