/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.render;

import com.davenonymous.pipegoggles.lib.gui.GUIHelper;
import com.davenonymous.pipegoggles.lib.gui.Icons;
import com.davenonymous.pipegoggles.lib.gui.event.MouseDraggedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import com.davenonymous.pipegoggles.lib.gui.widgets.Widget;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetLabel;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetWithChoiceValue;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class WidgetSelectBar<T>
extends WidgetWithChoiceValue<T> {
    float sliderPosition = 0.0f;
    float lineWidth = 2.0f;
    int lineOffset = 4;
    int borderLineHeight = 8;
    int slotLineHeight = 5;
    int lineColor = -11513776;
    Function<T, Widget> labelProvider = t -> {
        WidgetLabel widget = new WidgetLabel(t.toString());
        widget.autoWidth(50);
        widget.setTextColor(this.lineColor);
        return widget;
    };
    Function<T, Float> positionProvider = t -> {
        float regularSpacing = 1.0f / (float)(this.choices.size() - 1);
        int choiceNum = this.choices.getPointerIndex();
        return Float.valueOf(regularSpacing * (float)choiceNum);
    };

    public WidgetSelectBar() {
        this.addListener(MouseDraggedEvent.class, (event, widget) -> {
            if (event.button() != 0) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            float mouseX = (float)this.getActualX() - (float)event.mouseX();
            float ratio = Math.abs(mouseX / (float)(this.width - 1));
            this.sliderPosition = Math.max(0.0f, Math.min(1.0f, ratio));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseReleasedEvent.class, (event, widget) -> {
            if (event.button != 0) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            T closestChoice = this.getClosestChoice(this.sliderPosition);
            if (closestChoice != null) {
                this.setValue(closestChoice, true);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    private T getClosestChoice(float position) {
        if (this.choices.isEmpty()) {
            return null;
        }
        float closestDistance = Float.MAX_VALUE;
        T closestChoice = null;
        for (Object choice : this.choices) {
            float choicePosition = this.positionProvider.apply(choice).floatValue();
            float distance = Math.abs(choicePosition - position);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestChoice = (T)choice;
        }
        return closestChoice;
    }

    public WidgetSelectBar<T> setLabelProvider(Function<T, Widget> labelProvider) {
        this.labelProvider = labelProvider;
        return this;
    }

    public WidgetSelectBar<T> setPositionProvider(Function<T, Float> positionProvider) {
        this.positionProvider = positionProvider;
        return this;
    }

    @Override
    public void setValue(T choice, boolean fireEvent) {
        super.setValue(choice, fireEvent);
        this.sliderPosition = this.positionProvider.apply(choice).floatValue();
    }

    private void drawSlider(GuiGraphics pGuiGraphics, Screen screen) {
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(this.sliderPosition * (float)(this.width - 1) - 4.0f, 0.0f, 0.0f);
        pGuiGraphics.blit(Icons.sliderPaddle, 0, 0, 0.0f, 0.0f, 7, 12, 7, 12);
        pGuiGraphics.pose().popPose();
    }

    private void drawBackgroundLine(GuiGraphics pGuiGraphics, Screen screen) {
        float centerY = this.lineOffset + 4;
        GUIHelper.drawFatLine(pGuiGraphics, this.lineWidth / 2.0f, centerY, this.width - 1, centerY, this.lineWidth, this.lineColor);
        GUIHelper.drawFatLine(pGuiGraphics, 0.0f, centerY - (float)this.borderLineHeight / 2.0f, 0.0f, centerY + (float)this.borderLineHeight / 2.0f, this.lineWidth, this.lineColor);
        GUIHelper.drawFatLine(pGuiGraphics, this.width - 1, centerY - (float)this.borderLineHeight / 2.0f, this.width - 1, centerY + (float)this.borderLineHeight / 2.0f, this.lineWidth, this.lineColor);
        int choiceNum = 0;
        float regularSpacing = 1.0f / (float)(this.choices.size() - 1);
        for (Object choice : this.choices) {
            float position = this.positionProvider != null ? this.positionProvider.apply(choice).floatValue() : regularSpacing * (float)choiceNum;
            float x = position * (float)(this.width - 1);
            GUIHelper.drawFatLine(pGuiGraphics, x, centerY - (float)this.slotLineHeight / 2.0f, x, centerY + (float)this.slotLineHeight / 2.0f, this.lineWidth, this.lineColor);
            ++choiceNum;
            Widget label = this.labelProvider.apply(choice);
            float xShift = (float)label.width / 2.0f - 1.0f;
            label.setPosition(this.getActualX() + (int)x - (int)xShift, this.getActualY());
            label.setHeight(this.height);
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(x - xShift, (float)(this.lineOffset + 10), 100.0f);
            label.draw(pGuiGraphics, screen);
            pGuiGraphics.pose().popPose();
        }
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        int availableWidth = this.width;
        this.drawBackgroundLine(pGuiGraphics, screen);
        this.drawSlider(pGuiGraphics, screen);
        if (this.positionProvider != null) {
            // empty if block
        }
    }
}

