/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage;

import com.flanks255.pocketstorage.commands.PSUCommands;
import com.flanks255.pocketstorage.crafting.UpgradeRecipe;
import com.flanks255.pocketstorage.data.Generator;
import com.flanks255.pocketstorage.gui.PSUContainer;
import com.flanks255.pocketstorage.gui.PSUGui;
import com.flanks255.pocketstorage.inventory.StorageManager;
import com.flanks255.pocketstorage.items.PSUTier;
import com.flanks255.pocketstorage.items.PocketStorageUnit;
import com.flanks255.pocketstorage.network.PSUNetwork;
import com.flanks255.pocketstorage.util.RecipeUnlocker;
import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pocketstorage")
public class PocketStorage {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "pocketstorage";
    public static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((String)"pocketstorage");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> PSU_UUID = COMPONENTS.register("psu_uuid", () -> DataComponentType.builder().persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).build());
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"pocketstorage");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"pocketstorage");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"pocketstorage");
    public static final DeferredItem<Item> PSU1 = ITEMS.register("psu_1", () -> new PocketStorageUnit(PSUTier.TIER1));
    public static final DeferredItem<Item> PSU2 = ITEMS.register("psu_2", () -> new PocketStorageUnit(PSUTier.TIER2));
    public static final DeferredItem<Item> PSU3 = ITEMS.register("psu_3", () -> new PocketStorageUnit(PSUTier.TIER3));
    public static final DeferredItem<Item> PSU4 = ITEMS.register("psu_4", () -> new PocketStorageUnit(PSUTier.TIER4));
    public static final DeferredHolder<MenuType<?>, MenuType<PSUContainer>> PSUCONTAINER = CONTAINERS.register("psu_container", () -> IMenuTypeExtension.create(PSUContainer::fromNetwork));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<UpgradeRecipe>> UPGRADE_RECIPE = RECIPES.register("upgrade", UpgradeRecipe.Serializer::new);

    public PocketStorage(IEventBus bus) {
        IEventBus neoBus = NeoForge.EVENT_BUS;
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        COMPONENTS.register(bus);
        bus.addListener(Generator::gatherData);
        neoBus.addListener(this::onCommandsRegister);
        bus.addListener(this::registerCaps);
        bus.addListener(PSUNetwork::register);
        bus.addListener(this::setup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(this::menuScreenEvent);
            bus.addListener(this::creativeTabEvent);
        }
        neoBus.addListener(this::pickupEvent);
        neoBus.addListener(this::interactEvent);
        RecipeUnlocker.register(MODID, neoBus, 1);
    }

    private void pickupEvent(ItemEntityPickupEvent.Pre event) {
        if (event.getPlayer().containerMenu instanceof PSUContainer || event.getPlayer().isShiftKeyDown()) {
            return;
        }
        if (event.getItemEntity().hasPickUpDelay()) {
            return;
        }
        Inventory playerInv = event.getPlayer().getInventory();
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack = playerInv.getItem(i);
            if (!(stack.getItem() instanceof PocketStorageUnit) || !((PocketStorageUnit)stack.getItem()).pickupEvent(event, stack)) continue;
            return;
        }
    }

    private void interactEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getItemStack().getItem() instanceof PocketStorageUnit && event.getEntity().isShiftKeyDown()) {
            if (event.getSide() == LogicalSide.SERVER) {
                ((PocketStorageUnit)event.getItemStack().getItem()).onLeftClickEvent(event);
            }
            event.setCanceled(true);
        }
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        PSUCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void menuScreenEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)PSUCONTAINER.get(), PSUGui::new);
    }

    private void creativeTabEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().compareTo(CreativeModeTabs.TOOLS_AND_UTILITIES) == 0) {
            event.accept((ItemLike)PSU1.get());
            event.accept((ItemLike)PSU2.get());
            event.accept((ItemLike)PSU3.get());
            event.accept((ItemLike)PSU4.get());
        }
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> StorageManager.get().getCapability((ItemStack)stack), new ItemLike[]{PSU1, PSU2, PSU3, PSU4});
    }
}

