/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.inventory;

import com.flanks255.pocketstorage.PocketStorage;
import com.flanks255.pocketstorage.inventory.PSUData;
import com.flanks255.pocketstorage.inventory.PSUItemHandler;
import com.flanks255.pocketstorage.items.PSUTier;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class StorageManager
extends SavedData {
    private static final String NAME = "pocketstorage_data";
    private static final HashMap<UUID, PSUData> data = new HashMap();
    public static final StorageManager blankClient = new StorageManager();

    public static StorageManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (StorageManager)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(StorageManager::new, StorageManager::load), NAME);
        }
        return blankClient;
    }

    public HashMap<UUID, PSUData> getMap() {
        return data;
    }

    public Optional<PSUData> getStorage(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public PSUData getOrCreateStorage(UUID uuid, PSUTier tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.setDirty();
            return new PSUData((UUID)id, tier);
        });
    }

    public Optional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return Optional.empty();
    }

    public Optional<PSUItemHandler> getHandler(ItemStack stack) {
        UUID uuid;
        if (stack.has((DataComponentType)PocketStorage.PSU_UUID.get()) && data.containsKey(uuid = (UUID)stack.get((DataComponentType)PocketStorage.PSU_UUID.get()))) {
            return Optional.of(data.get(uuid).getHandler());
        }
        return Optional.empty();
    }

    public IItemHandler getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.has((DataComponentType)PocketStorage.PSU_UUID.get()) && data.containsKey(uuid = (UUID)stack.get((DataComponentType)PocketStorage.PSU_UUID.get()))) {
            return data.get(uuid).getHandler();
        }
        return null;
    }

    public static StorageManager load(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (nbt.contains("PSUS")) {
            ListTag list = nbt.getList("PSUS", 10);
            list.forEach(psuNBT -> PSUData.fromNBT((CompoundTag)psuNBT, pRegistries).ifPresent(psu -> data.put(psu.getUuid(), (PSUData)psu)));
        }
        return new StorageManager();
    }

    @Nonnull
    public CompoundTag save(CompoundTag compound, HolderLookup.Provider pRegistries) {
        ListTag backpacks = new ListTag();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT(pRegistries)));
        compound.put("PSUS", (Tag)backpacks);
        return compound;
    }
}

