/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.pop.client.pops;

import pro.mikey.mods.pop.data.AnimStage;

public class AnimTracker {
    private AnimStage stage = AnimStage.IN;
    private final int inDuration;
    private final int idleDuration;
    private final int outDuration;
    private long startTime;
    private int duration = 0;
    private boolean isDone = false;

    public AnimTracker(int duration, int inDuration, int outDuration) {
        this.inDuration = inDuration;
        this.outDuration = outDuration;
        this.idleDuration = duration - inDuration - outDuration;
    }

    public AnimTracker(int duration) {
        this(duration, 200, 200);
    }

    public void onRenderFrame() {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        long currentTime = System.nanoTime();
        this.duration = (int)((currentTime - this.startTime) / 1000000L);
        if (this.stage == AnimStage.IN) {
            if (this.duration >= this.inDuration) {
                this.stage = AnimStage.IDLE;
            }
        } else if (this.stage == AnimStage.IDLE) {
            if (this.duration >= this.inDuration + this.idleDuration) {
                this.stage = AnimStage.OUT;
            }
        } else if (this.stage == AnimStage.OUT && this.duration >= this.inDuration + this.idleDuration + this.outDuration) {
            this.isDone = true;
        }
    }

    public int currentStageCompletion() {
        if (this.stage == AnimStage.IN) {
            return this.duration * 100 / this.inDuration;
        }
        if (this.stage == AnimStage.IDLE) {
            return (this.duration - this.inDuration) * 100 / this.idleDuration;
        }
        if (this.stage == AnimStage.OUT) {
            return (this.duration - this.inDuration - this.idleDuration) * 100 / this.outDuration;
        }
        return 0;
    }

    public int totalDuration() {
        return this.inDuration + this.idleDuration + this.outDuration;
    }

    public AnimStage getStage() {
        return this.stage;
    }

    public int duration() {
        return this.duration;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

