/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.registry;

import cy.jdkdigital.productivelib.util.ImmutableFluidStack;
import cy.jdkdigital.productivemetalworks.ProductiveMetalworks;
import cy.jdkdigital.productivemetalworks.common.block.CastingBasinBlock;
import cy.jdkdigital.productivemetalworks.common.block.CastingTableBlock;
import cy.jdkdigital.productivemetalworks.common.block.FireBricksBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryCapacitorBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryControllerBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryDrainBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryTankBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryTapBlock;
import cy.jdkdigital.productivemetalworks.common.block.FoundryWindowBlock;
import cy.jdkdigital.productivemetalworks.common.block.HeatingCoilBlock;
import cy.jdkdigital.productivemetalworks.common.block.HotLiquidBlock;
import cy.jdkdigital.productivemetalworks.common.block.MeatBlock;
import cy.jdkdigital.productivemetalworks.common.block.entity.CastingBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryCapacitorBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryDrainBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTankBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTapBlockEntity;
import cy.jdkdigital.productivemetalworks.common.datamap.EntityMeltingMap;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.common.datamap.UnitMap;
import cy.jdkdigital.productivemetalworks.common.menu.FoundryControllerContainer;
import cy.jdkdigital.productivemetalworks.recipe.BlockCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.EntityMeltingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.FluidAlloyingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.util.CoilType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.Foods;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.datamaps.DataMapType;

public class MetalworksRegistrator {
    public static final DataMapType<Fluid, FuelMap> FUEL_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"fuel_map"), (ResourceKey)Registries.FLUID, FuelMap.CODEC).synced(FuelMap.CODEC, false).build();
    public static final DataMapType<Block, FuelMap> POWER_COIL_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"power_coil_map"), (ResourceKey)Registries.BLOCK, FuelMap.CODEC).synced(FuelMap.CODEC, false).build();
    public static final DataMapType<EntityType<?>, EntityMeltingMap> ENTITY_MELTING_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"entity_melting"), (ResourceKey)Registries.ENTITY_TYPE, EntityMeltingMap.CODEC).synced(EntityMeltingMap.CODEC, false).build();
    public static final DataMapType<Fluid, UnitMap> UNIT_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"unit_map"), (ResourceKey)Registries.FLUID, UnitMap.CODEC).synced(UnitMap.CODEC, false).build();
    public static final Supplier<DataComponentType<ImmutableFluidStack>> FLUID_STACK = ProductiveMetalworks.DATA_COMPONENTS.register("fluid_stack", () -> DataComponentType.builder().persistent(ImmutableFluidStack.CODEC).networkSynchronized(ImmutableFluidStack.STREAM_CODEC).build());
    public static final ResourceKey<DamageType> FOUNDRY_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"foundry_damage"));
    public static Map<String, Integer> FLUID_COLORS = new HashMap<String, Integer>();
    public static FluidType.Properties MOLTEN_FLUID_TYPE_PROPERTIES = FluidType.Properties.create().canSwim(false).canDrown(false).canConvertToSource(false).lightLevel(15).density(3000).viscosity(6000).temperature(1300).motionScale(0.002335).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.LAVA_EXTINGUISH);
    public static final Map<DyeColor, DeferredHolder<Block, Block>> FOUNDRY_CONTROLLERS = MetalworksRegistrator.registerDyedBlocks("foundry_controller", () -> new FoundryControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false ? 8 : 0).sound(SoundType.NETHER_BRICKS)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> FOUNDRY_DRAINS = MetalworksRegistrator.registerDyedBlocks("foundry_drain", () -> new FoundryDrainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).sound(SoundType.NETHER_BRICKS)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> FOUNDRY_TANKS = MetalworksRegistrator.registerDyedBlocks("foundry_tank", () -> new FoundryTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().sound(SoundType.NETHER_BRICKS)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> FOUNDRY_CAPACITORS = MetalworksRegistrator.registerDyedBlocks("foundry_capacitor", () -> new FoundryCapacitorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion().sound(SoundType.NETHER_BRICKS)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> FOUNDRY_WINDOWS = MetalworksRegistrator.registerDyedBlocks("foundry_window", () -> new FoundryWindowBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> FIRE_BRICKS = MetalworksRegistrator.registerDyedBlocks("fire_bricks", () -> new FireBricksBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).sound(SoundType.NETHER_BRICKS)));
    public static final DeferredHolder<Block, Block> FOUNDRY_TAP = MetalworksRegistrator.registerBlock("foundry_tap", () -> new FoundryTapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), true);
    public static final DeferredHolder<Block, Block> CASTING_BASIN = MetalworksRegistrator.registerBlock("casting_basin", () -> new CastingBasinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)), true);
    public static final DeferredHolder<Block, Block> CASTING_TABLE = MetalworksRegistrator.registerBlock("casting_table", () -> new CastingTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)), true);
    public static final DeferredHolder<Block, Block> LIQUID_HEATING_COIL = MetalworksRegistrator.registerBlock("liquid_heating_coil", () -> new HeatingCoilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false ? 7 : 0), CoilType.FLUID), true);
    public static final DeferredHolder<Block, Block> POWERED_HEATING_COIL = MetalworksRegistrator.registerBlock("powered_heating_coil", () -> new HeatingCoilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false ? 7 : 0), CoilType.ENERGY), true);
    public static final DeferredHolder<Block, Block> HIGH_POWERED_HEATING_COIL = MetalworksRegistrator.registerBlock("high_powered_heating_coil", () -> new HeatingCoilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.ATTACHED) != false ? 7 : 0), CoilType.ENERGY), true);
    public static final DeferredHolder<Block, Block> FIRE_CLAY = MetalworksRegistrator.registerBlock("fire_clay", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CLAY)), true);
    public static final DeferredHolder<Block, Block> MEAT_BLOCK = MetalworksRegistrator.registerBlock("meat_block", () -> new MeatBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).noOcclusion().sound(SoundType.SLIME_BLOCK)), new Item.Properties().craftRemainder(Items.BONE));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FoundryControllerBlockEntity>> FOUNDRY_CONTROLLER_BLOCK_ENTITY = ProductiveMetalworks.BLOCK_ENTITIES.register("foundry_controller", () -> BlockEntityType.Builder.of(FoundryControllerBlockEntity::new, (Block[])FOUNDRY_CONTROLLERS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FoundryDrainBlockEntity>> FOUNDRY_DRAIN_BLOCK_ENTITY = ProductiveMetalworks.BLOCK_ENTITIES.register("foundry_drain", () -> BlockEntityType.Builder.of(FoundryDrainBlockEntity::new, (Block[])FOUNDRY_DRAINS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FoundryTankBlockEntity>> FOUNDRY_TANK_BLOCK_ENTITY = ProductiveMetalworks.BLOCK_ENTITIES.register("foundry_tank", () -> BlockEntityType.Builder.of(FoundryTankBlockEntity::new, (Block[])FOUNDRY_TANKS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FoundryCapacitorBlockEntity>> FOUNDRY_CAPACITOR_BLOCK_ENTITY = ProductiveMetalworks.BLOCK_ENTITIES.register("foundry_capacitor", () -> BlockEntityType.Builder.of(FoundryCapacitorBlockEntity::new, (Block[])FOUNDRY_CAPACITORS.values().stream().map(DeferredHolder::get).toList().toArray(new Block[0])).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FoundryTapBlockEntity>> FOUNDRY_TAP_BLOCK_ENTITY = ProductiveMetalworks.BLOCK_ENTITIES.register("foundry_tap", () -> BlockEntityType.Builder.of(FoundryTapBlockEntity::new, (Block[])new Block[]{(Block)FOUNDRY_TAP.get()}).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<CastingBlockEntity>> CASTING_BLOCK_ENTITY = ProductiveMetalworks.BLOCK_ENTITIES.register("casting", () -> BlockEntityType.Builder.of(CastingBlockEntity::new, (Block[])new Block[]{(Block)CASTING_TABLE.get(), (Block)CASTING_BASIN.get()}).build(null));
    public static DeferredHolder<Item, Item> FIRE_BRICK = MetalworksRegistrator.registerItem("fire_brick");
    public static DeferredHolder<Item, Item> MEAT_NUGGET = MetalworksRegistrator.registerItem("meat_nugget", () -> new Item(new Item.Properties().food(Foods.DRIED_KELP)));
    public static DeferredHolder<Item, Item> MEAT_INGOT = MetalworksRegistrator.registerItem("meat_ingot", () -> new Item(new Item.Properties().food(Foods.PUMPKIN_PIE)));
    public static DeferredHolder<Item, Item> SHINY_MEAT_INGOT = MetalworksRegistrator.registerItem("shiny_meat_ingot", () -> new Item(new Item.Properties().food(Foods.GOLDEN_CARROT)));
    public static DeferredHolder<Item, Item> CAST_INGOT = MetalworksRegistrator.registerItem("ingot_cast");
    public static DeferredHolder<Item, Item> CAST_NUGGET = MetalworksRegistrator.registerItem("nugget_cast");
    public static DeferredHolder<Item, Item> CAST_GEM = MetalworksRegistrator.registerItem("gem_cast");
    public static DeferredHolder<Item, Item> CAST_GEAR = MetalworksRegistrator.registerItem("gear_cast");
    public static DeferredHolder<Item, Item> CAST_ROD = MetalworksRegistrator.registerItem("rod_cast");
    public static DeferredHolder<Item, Item> CAST_PLATE = MetalworksRegistrator.registerItem("plate_cast");
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_HEAVY_CORE = MetalworksRegistrator.registerFluid("molten_heavy_core", -10262666);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_AMETHYST = MetalworksRegistrator.registerFluid("molten_amethyst", -3170061);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_GLOWSTONE = MetalworksRegistrator.registerFluid("molten_glowstone", -271756);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_REDSTONE = MetalworksRegistrator.registerFluid("molten_redstone", -6023160);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_OBSIDIAN = MetalworksRegistrator.registerFluid("molten_obsidian", -15725540);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_GLASS = MetalworksRegistrator.registerFluid("molten_glass", -3085591);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_EMERALD = MetalworksRegistrator.registerFluid("molten_emerald", -15213214);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_DIAMOND = MetalworksRegistrator.registerFluid("molten_diamond", -11801114);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_LAPIS = MetalworksRegistrator.registerFluid("molten_lapis", -14927728);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_QUARTZ = MetalworksRegistrator.registerFluid("molten_quartz", -1120546);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_CARBON = MetalworksRegistrator.registerFluid("molten_carbon", -15990783);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_ENDER = MetalworksRegistrator.registerFluid("molten_ender", -15704495);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_ANCIENT_DEBRIS = MetalworksRegistrator.registerFluid("molten_ancient_debris", -11916253);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_SHULKER_SHELL = MetalworksRegistrator.registerFluid("molten_shulker_shell", -6985579);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_BLAZE = MetalworksRegistrator.registerFluid("molten_blaze", -210688);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_SLIME = MetalworksRegistrator.registerFluid("molten_slime", -11104434);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_MAGMA_CREAM = MetalworksRegistrator.registerFluid("molten_magma_cream", -1476573);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_WAX = MetalworksRegistrator.registerFluid("molten_wax", -18424);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> LIQUID_MEAT = MetalworksRegistrator.registerFluid("meat", -176537);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_IRON = MetalworksRegistrator.registerFluid("molten_iron", -3892115);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_COPPER = MetalworksRegistrator.registerFluid("molten_copper", -3774656);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_GOLD = MetalworksRegistrator.registerFluid("molten_gold", -1918680);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_NETHERITE = MetalworksRegistrator.registerFluid("molten_netherite", -14277082);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_ALUMINUM = MetalworksRegistrator.registerFluid("molten_aluminum", -1842205);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_LEAD = MetalworksRegistrator.registerFluid("molten_lead", -8614714);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_NICKEL = MetalworksRegistrator.registerFluid("molten_nickel", -5658236);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_OSMIUM = MetalworksRegistrator.registerFluid("molten_osmium", -4142627);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_PLATINUM = MetalworksRegistrator.registerFluid("molten_platinum", -4868609);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_SILVER = MetalworksRegistrator.registerFluid("molten_silver", -5971737);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_TIN = MetalworksRegistrator.registerFluid("molten_tin", -8882056);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_URANIUM = MetalworksRegistrator.registerFluid("molten_uranium", -8460424);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_ZINC = MetalworksRegistrator.registerFluid("molten_zinc", -4868683);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_IRIDIUM = MetalworksRegistrator.registerFluid("molten_iridium", -4144960);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_STEEL = MetalworksRegistrator.registerFluid("molten_steel", -9868951);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_INVAR = MetalworksRegistrator.registerFluid("molten_invar", -3158065);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_ELECTRUM = MetalworksRegistrator.registerFluid("molten_electrum", -1055310);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_BRONZE = MetalworksRegistrator.registerFluid("molten_bronze", -2520515);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_BRASS = MetalworksRegistrator.registerFluid("molten_brass", -738747);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_ENDERIUM = MetalworksRegistrator.registerFluid("molten_enderium", -15834012);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_LUMIUM = MetalworksRegistrator.registerFluid("molten_lumium", -9602);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_SIGNALUM = MetalworksRegistrator.registerFluid("molten_signalum", -2392299);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_CONSTANTAN = MetalworksRegistrator.registerFluid("molten_constantan", -2444402);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_REFINED_GLOWSTONE = MetalworksRegistrator.registerFluid("molten_refined_glowstone", -5133738);
    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> MOLTEN_REFINED_OBSIDIAN = MetalworksRegistrator.registerFluid("molten_refined_obsidian", -10138487);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> FLUID_ALLOYING = ProductiveMetalworks.RECIPE_SERIALIZERS.register("fluid_alloying", FluidAlloyingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<FluidAlloyingRecipe>> FLUID_ALLOYING_TYPE = ProductiveMetalworks.RECIPE_TYPES.register("fluid_alloying", () -> new RecipeType<FluidAlloyingRecipe>(){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> ITEM_MELTING = ProductiveMetalworks.RECIPE_SERIALIZERS.register("item_melting", ItemMeltingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> ENTITY_MELTING = ProductiveMetalworks.RECIPE_SERIALIZERS.register("entity_melting", EntityMeltingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<ItemMeltingRecipe>> ITEM_MELTING_TYPE = ProductiveMetalworks.RECIPE_TYPES.register("item_melting", () -> new RecipeType<ItemMeltingRecipe>(){});
    public static final DeferredHolder<RecipeType<?>, RecipeType<EntityMeltingRecipe>> ENTITY_MELTING_TYPE = ProductiveMetalworks.RECIPE_TYPES.register("entity_melting", () -> new RecipeType<EntityMeltingRecipe>(){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> BLOCK_CASTING = ProductiveMetalworks.RECIPE_SERIALIZERS.register("block_casting", BlockCastingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<BlockCastingRecipe>> BLOCK_CASTING_TYPE = ProductiveMetalworks.RECIPE_TYPES.register("block_casting", () -> new RecipeType<BlockCastingRecipe>(){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> ITEM_CASTING = ProductiveMetalworks.RECIPE_SERIALIZERS.register("item_casting", ItemCastingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<ItemCastingRecipe>> ITEM_CASTING_TYPE = ProductiveMetalworks.RECIPE_TYPES.register("item_casting", () -> new RecipeType<ItemCastingRecipe>(){});
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"productivemetalworks"));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = ProductiveMetalworks.CREATIVE_MODE_TABS.register("productivemetalworks", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.productivemetalworks")).icon(() -> ((Block)FOUNDRY_CONTROLLERS.get(DyeColor.BLACK).get()).asItem().getDefaultInstance()).build());
    public static final DeferredHolder<MenuType<?>, MenuType<FoundryControllerContainer>> FOUNDRY_CONTROLLER_CONTAINER = ProductiveMetalworks.CONTAINER_TYPES.register("foundry_controller", () -> IMenuTypeExtension.create(FoundryControllerContainer::new));

    public static void register() {
    }

    public static DeferredHolder<Item, Item> registerItem(String name) {
        return MetalworksRegistrator.registerItem(name, () -> new Item(new Item.Properties()));
    }

    public static DeferredHolder<Item, Item> registerItem(String name, Supplier<Item> supplier) {
        return ProductiveMetalworks.ITEMS.register(name, supplier);
    }

    public static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> supplier, boolean hasItem) {
        return MetalworksRegistrator.registerBlock(name, supplier, hasItem ? new Item.Properties() : null);
    }

    public static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> supplier, Item.Properties properties) {
        DeferredBlock block = ProductiveMetalworks.BLOCKS.register(name, supplier);
        if (properties != null) {
            MetalworksRegistrator.registerItem(name, () -> new BlockItem((Block)block.get(), properties));
        }
        return block;
    }

    public static Map<DyeColor, DeferredHolder<Block, Block>> registerDyedBlocks(String name, Supplier<Block> supplier) {
        HashMap<DyeColor, DeferredHolder<Block, Block>> blocks = new HashMap<DyeColor, DeferredHolder<Block, Block>>();
        for (DyeColor color : DyeColor.values()) {
            DeferredBlock block = ProductiveMetalworks.BLOCKS.register(color.getSerializedName() + "_" + name, supplier);
            MetalworksRegistrator.registerItem(color.getSerializedName() + "_" + name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            blocks.put(color, (DeferredHolder<Block, Block>)block);
        }
        return blocks;
    }

    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> registerFluid(String name, int color) {
        FLUID_COLORS.put(name, color);
        DeferredHolder TYPE = ProductiveMetalworks.FLUID_TYPES.register(name, () -> new FluidType(MOLTEN_FLUID_TYPE_PROPERTIES));
        DeferredHolder MOLTEN = ProductiveMetalworks.FLUIDS.register(name, () -> new BaseFlowingFluid.Source(MetalworksRegistrator.makeMoltenProperties((Supplier<? extends FluidType>)TYPE, name)));
        ProductiveMetalworks.FLUIDS.register(String.format("flowing_%s", name), () -> new BaseFlowingFluid.Flowing(MetalworksRegistrator.makeMoltenProperties((Supplier<? extends FluidType>)TYPE, name)));
        MetalworksRegistrator.registerItem(String.format("%s_bucket", name), () -> new BucketItem((Fluid)MOLTEN.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        MetalworksRegistrator.registerBlock(name, () -> new HotLiquidBlock((FlowingFluid)MOLTEN.get(), BlockBehaviour.Properties.of().strength(100.0f).speedFactor(0.7f).noCollission().liquid().replaceable().lightLevel(value -> 15)), false);
        return MOLTEN;
    }

    private static BaseFlowingFluid.Properties makeMoltenProperties(Supplier<? extends FluidType> fluidType, String name) {
        return new BaseFlowingFluid.Properties(fluidType, (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)name)), (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)String.format("flowing_%s", name)))).bucket((Supplier)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)String.format("%s_bucket", name)))).block((Supplier)DeferredHolder.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)name))).tickRate(30).slopeFindDistance(4).levelDecreasePerBlock(2);
    }
}

