/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.MutablePatternPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MutableTaskPlan {
    @Nullable
    private final Pattern rootPattern;
    @Nullable
    private final ResourceKey resource;
    private final long amount;
    private final Map<Pattern, MutablePatternPlan> patterns;
    private final MutableResourceList initialRequirements;
    private boolean missing;

    MutableTaskPlan() {
        this(null, null, 0L, new LinkedHashMap<Pattern, MutablePatternPlan>(), MutableResourceListImpl.create(), false);
    }

    private MutableTaskPlan(@Nullable Pattern rootPattern, @Nullable ResourceKey resource, long amount, Map<Pattern, MutablePatternPlan> patterns, MutableResourceList initialRequirements, boolean missing) {
        this.rootPattern = rootPattern;
        this.resource = resource;
        this.amount = amount;
        this.patterns = patterns;
        this.initialRequirements = initialRequirements;
        this.missing = missing;
    }

    void addOrUpdatePattern(Pattern usedPattern, long iterations) {
        this.patterns.computeIfAbsent(usedPattern, p -> new MutablePatternPlan((Pattern)p, p.equals(this.rootPattern))).addIterations(iterations);
    }

    void addToExtract(ResourceKey toExtract, long toExtractAmount) {
        this.initialRequirements.add(toExtract, toExtractAmount);
    }

    void addUsedIngredient(Pattern ingredientPattern, int ingredientIndex, ResourceKey ingredient, long ingredientAmount) {
        MutablePatternPlan patternPlan = Objects.requireNonNull(this.patterns.get(ingredientPattern));
        patternPlan.addUsedIngredient(ingredientIndex, ingredient, ingredientAmount);
    }

    MutableTaskPlan copy(Pattern childPattern, ResourceKey childResource, long totalAmount) {
        LinkedHashMap<Pattern, MutablePatternPlan> patternsCopy = new LinkedHashMap<Pattern, MutablePatternPlan>();
        for (Map.Entry<Pattern, MutablePatternPlan> entry : this.patterns.entrySet()) {
            patternsCopy.put(entry.getKey(), entry.getValue().copy());
        }
        return new MutableTaskPlan(this.rootPattern == null ? childPattern : this.rootPattern, this.resource == null ? childResource : this.resource, this.resource == null ? totalAmount : this.amount, patternsCopy, this.initialRequirements.copy(), this.missing);
    }

    Optional<TaskPlan> getPlan() {
        if (this.missing || this.rootPattern == null || this.resource == null) {
            return Optional.empty();
        }
        Map<Pattern, TaskPlan.PatternPlan> finalPatterns = Collections.unmodifiableMap(this.patterns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MutablePatternPlan)e.getValue()).getPlan(), (a, b) -> a, LinkedHashMap::new)));
        return Optional.of(new TaskPlan(this.resource, this.amount, this.rootPattern, finalPatterns, this.initialRequirements.copyState()));
    }

    void setMissing() {
        this.missing = true;
    }
}

