/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.core.component;

import com.refinedmods.refinedstorage.api.core.component.ComponentAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.4")
public class ComponentMap<C>
implements ComponentAccessor<C> {
    private final Map<Class<? extends C>, C> map;

    public ComponentMap(Map<Class<? extends C>, C> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public Collection<C> getComponents() {
        return this.map.values();
    }

    @Override
    public <I extends C> I getComponent(Class<I> componentType) {
        if (!this.map.containsKey(componentType)) {
            throw new IllegalArgumentException("Component not present: " + String.valueOf(componentType));
        }
        return (I)this.map.get(componentType);
    }
}

