/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.importer;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public class ImporterNetworkNode
extends AbstractNetworkNode {
    private final Filter filter = new Filter();
    private final Actor actor = new NetworkNodeActor(this);
    private long energyUsage;
    @Nullable
    private ImporterTransferStrategy transferStrategy;

    public ImporterNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    public void setTransferStrategy(ImporterTransferStrategy transferStrategy) {
        this.transferStrategy = transferStrategy;
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive() || this.transferStrategy == null) {
            return;
        }
        this.transferStrategy.transfer(this.filter, this.actor, this.network);
    }

    public FilterMode getFilterMode() {
        return this.filter.getMode();
    }

    public void setFilterMode(FilterMode mode) {
        this.filter.setMode(mode);
    }

    public void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.filter.setNormalizer(normalizer);
    }

    public void setFilters(Set<ResourceKey> filters) {
        this.filter.setFilters(filters);
    }

    public void setEnergyUsage(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage;
    }
}

