/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferListener;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TransferHelper;
import com.refinedmods.refinedstorage.api.storage.limited.LimitedStorage;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public class StorageTransferNetworkNode
extends AbstractStorageContainerNetworkNode {
    private final Actor actor = new NetworkNodeActor(this);
    private final Filter filter = new Filter();
    private StorageTransferMode mode = StorageTransferMode.INSERT_INTO_NETWORK;
    @Nullable
    private ToLongFunction<Storage> transferQuotaProvider;
    @Nullable
    private StorageTransferListener listener;

    public StorageTransferNetworkNode(long energyUsage, long energyUsagePerStorage, int size) {
        super(energyUsage, energyUsagePerStorage, size);
    }

    public void setMode(StorageTransferMode mode) {
        this.mode = mode;
    }

    public StorageTransferMode getMode() {
        return this.mode;
    }

    public void setTransferQuotaProvider(ToLongFunction<Storage> transferQuotaProvider) {
        this.transferQuotaProvider = transferQuotaProvider;
    }

    public void setListener(@Nullable StorageTransferListener listener) {
        this.listener = listener;
    }

    public FilterMode getFilterMode() {
        return this.filter.getMode();
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filter.setMode(filterMode);
    }

    public void setFilters(Set<ResourceKey> filters) {
        this.filter.setFilters(filters);
    }

    public void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.filter.setNormalizer(normalizer);
    }

    @Override
    public void doWork() {
        super.doWork();
        if (!this.isActive() || this.network == null) {
            return;
        }
        StorageNetworkComponent networkStorage = this.network.getComponent(StorageNetworkComponent.class);
        for (int i = 0; i < this.storages.length / 2; ++i) {
            Result result;
            StateTrackedStorage storage = this.storages[i];
            if (storage == null || !this.processResult(result = this.transfer(storage, networkStorage), i)) continue;
            return;
        }
    }

    private Result transfer(StateTrackedStorage storage, StorageNetworkComponent networkStorage) {
        if (this.transferQuotaProvider == null) {
            return Result.FAILURE;
        }
        long transferQuota = this.transferQuotaProvider.applyAsLong(storage.getDelegate());
        if (this.mode == StorageTransferMode.INSERT_INTO_NETWORK) {
            return this.transfer(storage, networkStorage, transferQuota, this::hasNoExtractableResources);
        }
        return this.transfer(networkStorage, storage, transferQuota, source -> this.hasNoExtractableResources((Storage)source) || this.storageIsFull(storage));
    }

    private Result transfer(Storage source, Storage destination, long transferQuota, Predicate<Storage> readyPredicate) {
        if (readyPredicate.test(source)) {
            return Result.SUCCESS;
        }
        if (this.transfer(source, destination, transferQuota)) {
            return readyPredicate.test(source) ? Result.SUCCESS : Result.PARTIAL;
        }
        return Result.FAILURE;
    }

    private boolean transfer(Storage source, Storage destination, long transferQuota) {
        long remainder = transferQuota;
        LinkedHashSet<ResourceAmount> sourceContents = new LinkedHashSet<ResourceAmount>(source.getAll());
        for (ResourceAmount resourceAmount : sourceContents) {
            long amount;
            long transferred;
            ResourceKey resource = resourceAmount.resource();
            if (!this.filter.isAllowed(resource) || (remainder -= (transferred = TransferHelper.transfer(resource, amount = Math.min(remainder, resourceAmount.amount()), this.actor, source, destination, source))) != 0L) continue;
            return true;
        }
        return remainder != transferQuota;
    }

    private boolean hasNoExtractableResources(Storage source) {
        return source.getAll().stream().noneMatch(resourceAmount -> this.filter.isAllowed(resourceAmount.resource()));
    }

    private boolean storageIsFull(Storage storage) {
        LimitedStorage limitedStorage;
        return storage instanceof LimitedStorage && (limitedStorage = (LimitedStorage)storage).getCapacity() > 0L && limitedStorage.getCapacity() == limitedStorage.getStored();
    }

    private boolean processResult(Result result, int index) {
        if (result.isSuccess()) {
            if (result == Result.SUCCESS && this.listener != null) {
                this.listener.onTransferSuccess(index);
            }
            return true;
        }
        return false;
    }

    private static enum Result {
        SUCCESS,
        PARTIAL,
        FAILURE;


        private boolean isSuccess() {
            return this == PARTIAL || this == SUCCESS;
        }
    }
}

