/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.mixin;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContainerMenuMixin.class);
    @Shadow
    @Final
    public NonNullList<Slot> slots;

    @Shadow
    public abstract ItemStack getCarried();

    @Shadow
    public abstract void setCarried(ItemStack var1);

    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void doClick(int slotId, int button, ClickType clickType, Player player, CallbackInfo ci) {
        ItemStack copy;
        if (clickType != ClickType.CLONE || !player.hasInfiniteMaterials() || !this.getCarried().isEmpty() || slotId < 0) {
            return;
        }
        Slot slot = (Slot)this.slots.get(slotId);
        if (!slot.hasItem()) {
            return;
        }
        ItemStack stack = slot.getItem();
        StorageContainerItemHelper helper = RefinedStorageApi.INSTANCE.getStorageContainerItemHelper();
        if (helper.clear(copy = stack.copy())) {
            LOGGER.info("Cleared storage reference of storage container {}", (Object)copy);
            this.setCarried(copy.copyWithCount(stack.getMaxStackSize()));
            ci.cancel();
        }
    }
}

